@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.jeune_enfant.update', $projet->id_projet) }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    @method('PUT') 
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
            <h3>{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

{{-- status card --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
    <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
    @switch($projet->id_statut)
      @case(1)<span class="status-badge status-badge--success">مقبول</span>@break
      @case(3)<span class="status-badge status-badge--danger">مرفوض</span>@break
      @case(4)<span class="status-badge status-badge--warning">موافقة شريطة</span>@break
      @case(5)<span class="status-badge status-badge--info">إرجاء لإبداء الرأي</span>@break
      @case(2)<span class="status-badge status-badge--pending">في الانتظار</span>@break
      @case(6)<span class="status-badge status-badge--secondary">مسودّة</span>@break
      @default <span class="status-badge status-badge--secondary">غير محدد</span>
    @endswitch
  </div>

  <div class="card-body">
    <p class="text-muted mb-4 text-center fs-6">إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:</p>

    <div class="form-group row align-items-center mb-3">
      <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
      <div class="col-sm-4">
        <select required class="form-control" id="id_statut" name="id_statut">
          <option value="">اختر...</option>
          @foreach($statuts as $s)
            @php
              $statutId = $s->id_statut ?? $s->id ?? null;
              if (in_array($statutId, [2, 6])) continue; // hide pending & draft
              $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? '—';
              $selected = (string) old('id_statut', $projet->id_statut ?? '') === (string) $statutId;
            @endphp
            <option value="{{ $statutId }}" {{ $selected ? 'selected' : '' }}>{{ $label }}</option>
          @endforeach
        </select>
      </div>
    </div>

    {{-- single textarea used for all comment types (id/name commentaire_motif) --}}
<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق"></textarea>
</div>

{{-- reject textarea shown only when status == 3 --}}
<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
  <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض"></textarea>
</div>
  </div>
</div>

{{-- history card (compact) --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2"><h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5></div>

  <div class="card-body p-2" dir="rtl">
    @if( ! isset($projet->statutHistories) || $projet->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($projet->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

{{-- small CSS (reuse your existing styles) --}}
<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
  

  <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="{{ old('nom_prenom', $projet->investissements->first()?->utilisateur->nom_prenom) }}" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="{{ old('lieu_naissance', $projet->investissements->first()?->utilisateur->lieu_naissance) }}" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="{{ old('date_naissance', $projet->investissements->first()?->utilisateur->date_naissance) }}">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" 
                                {{ old('id_type_identite', $projet->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="{{ old('cin', $projet->investissements->first()?->utilisateur->cin) }}" 
                           placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="{{ old('passport', $projet->investissements->first()?->utilisateur->passport) }}" 
                           placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="{{ old('num_fiscal', $projet->investissements->first()?->utilisateur->num_fiscal) }}" 
                           placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none' }};">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="{{ old('date_delivrance_cin', $projet->investissements->first()?->utilisateur->date_delivrance_cin) }}">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="{{ old('lieu_delivrance_cin', $projet->investissements->first()?->utilisateur->lieu_delivrance_cin) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="{{ old('adresse', $projet->investissements->first()?->utilisateur->adresse) }}" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="{{ old('niveau_etude', $projet->investissements->first()?->utilisateur->niveau_etude) }}" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="{{ old('dernier_diplome', $projet->investissements->first()?->utilisateur->dernier_diplome) }}" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="{{ old('experience', $projet->investissements->first()?->utilisateur->experience) }}" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>خصائص المشروع الترفيهي</h4>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_spectacle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_spectacle" name="espace_spectacle" value="1"
                       {{ old('espace_spectacle', $projet->espace_spectacle) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_spectacle">
                    فضاءات ترفيهية و الهواء الطلق و العروض
                </label>
            </div>
            <div class="mt-3" id="caracteristique_group" style="display:{{ $projet->espace_spectacle ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_spec" placeholder="خصوصياتها" rows="3">{{ old('caracteristique_spec', $projet->caracteristique_spec) }}</textarea>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_sportif" name="espace_sportif" value="1"
                       {{ old('espace_sportif', $projet->espace_sportif) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_sportif">فضاءات ترفيهية رياضية</label>
            </div>
            <div class="mt-3" id="caracteristique_sportif_group" style="display:{{ $projet->espace_sportif ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_sportif" rows="3">{{ old('caracteristique_sportif', $projet->caracteristique_sportif) }}</textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_service" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_service" name="espace_activite_service" value="1"
                       {{ old('espace_activite_service', $projet->espace_activite_service) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_activite_service">فضاء الأنشطة الخدماتية</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_serv_group" style="display:{{ $projet->espace_activite_service ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_serv" rows="3">{{ old('caracteristique_activite_serv', $projet->caracteristique_activite_serv) }}</textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_culturelle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_culturelle" name="espace_activite_culturelle" value="1"
                       {{ old('espace_activite_culturelle', $projet->espace_activite_culturelle) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_activite_culturelle">فضاء الأنشطة القافية و الفنية و العلمية</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_cult_group" style="display:{{ $projet->espace_activite_culturelle ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_cult" rows="3">{{ old('caracteristique_activite_cult', $projet->caracteristique_activite_cult) }}</textarea>
            </div>
        </div>
        <div class="form-section mt-4">
            <h4>طبيعة المشروع</h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">الرجاء اختيار طبيعة المشروع</label>
                </div>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled>اختر...</option>
                        @foreach($naturesProjet as $nature)
                            <option value="{{ $nature->id_nature_p }}" 
                                {{ old('nature_projet_id', $projet->nature_projet_id) == $nature->id_nature_p ? 'selected' : '' }}>
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> عدد مواطن الشخل المؤملة </h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">من حاملي الشهادات العلمية</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_diplome_universitaire" 
                           value="{{ old('nbr_diplome_universitaire', $projet->nbr_diplome_universitaire) }}" 
                           placeholder="من حاملي الشهادات العلمية">
                </div>

                <label class="col-sm-2 col-form-label">اخرين</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_autre" 
                           value="{{ old('nbr_autre', $projet->nbr_autre) }}" placeholder="اخرين">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> مدير المؤسسة </h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" 
                           value="{{ old('nom_prenom_d', $projet->directeur->nom_prenom_d) }}" maxlength="50">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية  </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" 
                           value="{{ old('num_cin', $projet->directeur->num_cin) }}" maxlength="8">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_delivrance" 
                           value="{{ old('date_delivrance', $projet->directeur->date_delivrance) }}">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_delivrance" 
                           value="{{ old('lieu_delivrance', $projet->directeur->lieu_delivrance) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="{{ old('niveau_etude', $projet->directeur->niveau_etude) }}">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_obtenu" 
                           value="{{ old('dernier_diplome_obtenu', $projet->directeur->dernier_diplome_obtenu) }}">
                </div>
            </div>
        </div>

        <h4>بيانات عن الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>المبلغ</th>
                        <th>مصادر التمويل</th>
                        <th>الملاحظات</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    @foreach($projet->investissements as $index => $inv)
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[{{ $index }}][secteur_invest_id]">
                                <option value="" disabled>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}" 
                                        {{ $inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : '' }}>
                                        {{ $secteur->secteur_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="المبلغ">
                            <input type="number" name="investissements[{{ $index }}][montant_inv]" class="form-control" value="{{ $inv->montant_inv }}">
                        </td>
                        <td data-label="مصادر التمويل">
                            <input type="text" name="investissements[{{ $index }}][source]" class="form-control" value="{{ $inv->source }}" maxlength="100">
                        </td>
                        <td data-label="الملاحظات">
                            <input type="text" name="investissements[{{ $index }}][remarques]" class="form-control" value="{{ $inv->remarques }}" maxlength="200">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <button type="button" class="btn btn-primary mt-2" onclick="addInvestissementRow()" style="background-color: #28a745; border-color: #28a745;">
                إضافة صف
            </button>
        </div>

        <span class="text-muted">(*) اموال ذاتية, قروض طويلة المدى, قروض متوسطة المدى, قروض صغيرة المدى, منح, مواد اخرى.</span>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $projet->remarques) }}</textarea>
        </div>

        
		  <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="{{ route('admin.jeune_enfant.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
        textareaGroup.style.display = checkbox.checked ? "block" : "none";
        checkbox.addEventListener("change", function() {
            textareaGroup.style.display = this.checked ? "block" : "none";
        });
    }
    toggleTextarea("espace_spectacle", "caracteristique_group");
    toggleTextarea("espace_sportif", "caracteristique_sportif_group");
    toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
    toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");
});
</script>

<script>
let investIndex = {{ $projet->investissements->count() }};
function addInvestissementRow() {
    let tableBody = document.getElementById('investissement-body');
    let newRow = `
        <tr>
            <td data-label="الإستثمار">
                <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]">
                    <option value="" disabled selected>اختر...</option>
                    @foreach($secteurs as $secteur)
                        <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                    @endforeach
                </select>
            </td>
            <td data-label="المبلغ">
                <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" placeholder="المبلغ">
            </td>
            <td data-label="مصادر التمويل">
                <input type="text" name="investissements[${investIndex}][source]" class="form-control" placeholder="مصادر التمويل" maxlength="100">
            </td>
            <td data-label="الملاحظات">
                <input type="text" name="investissements[${investIndex}][remarques]" class="form-control" placeholder="الملاحظات" maxlength="200">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    investIndex++;
}

function removeRow(button) {
    let row = button.closest('tr');
    row.remove();
}
</script>

@else
<script>
    window.location.href = "{{ route('login') }}";
</script>
@endif
@endsection
