@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="" method="POST" enctype="multipart/form-data" lang="ar">

     
        <h3 style="font-size:25px;">{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;padding-top:20px;">إستمارة تسجيل الإنتفاع بإعفاء جبائي</h4>
        <br>

            <div class="d-flex align-items-center mb-3">
    <h5 class="mb-0 fw-bold me-2">الوضعية الحالية:</h5>

    @switch($document->id_statut)

        @case(1)
            <span><strong> قبول</strong></span>
            @break

        @case(2)
            <span><strong>في الانتظار</strong></span>
            @break

        @case(3)
            <span><strong>رفض</strong></span>
            @break

        @case(4)
            <span><strong>موافقة شريطة</strong></span>
            @break

        @case(5)
            <span><strong>إرجاء لإبداء الرأي</strong></span>
            @break

        @case(6)
            <span><strong>مسودّة</strong></span>
            @break

        @default
            <span><strong>غير محدد</strong></span>

    @endswitch
</div>

        @if($document->id_statut == 3 && !empty($document->commentaire_motif))
            <div class="mb-3">
                <label class="fw-bold text-danger mb-0">سبب الرفض:</label>
                <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $document->commentaire_motif }}</p>
            </div>
        @endif

        @if($document->id_statut == 4 && !empty($document->commentaire_acceptation))
            <div class="mb-3">
                <label class="fw-bold text-warning mb-0">تعليق:</label>
                <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $document->commentaire_acceptation }}</p>
            </div>
        @endif

        @if($document->id_statut == 5 && !empty($document->commentaire_avis))
            <div class="mb-3">
                <label class="fw-bold text-primary mb-0">تعليق:</label>
                <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $document->commentaire_avis }}</p>
            </div>
        @endif

<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5>
  </div>

  <div class="card-body p-2" dir="rtl">
    @if($document->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($document->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to   = optional($hist->toStatut)->statut_ar   ?? optional($hist->toStatut)->libelle_ar   ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId == 1 ? 'badge-success' : ($toId == 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>


        <div class="form-section">
            <h4>هوية صاحب المشروع</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">{{ $document->utilisateur->nom_prenom ?? '-' }}</div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم الهاتف</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">{{ $document->utilisateur->tel ?? '-' }}</div>
                </div>

                <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">{{ $document->utilisateur->email ?? '-' }}</div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">{{ $document->utilisateur->adresse ?? '-' }}</div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عنوان المشروع</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">{{ $document->nom_projet ?? '-' }}</div>
                </div>

                <label class="col-sm-2 col-form-label">مكان المشروع</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">{{ $document->adresse_projet ?? '-' }}</div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>الوثائق المرفقة</h4>
            @php
                $files = [
                    'copie_cahier_des_charges','copie_originale','facture','contrat','fichier_arrivage','fichier_colisage',
                    'copie_registre_fiscal','copie_registre_national_institutions','copie_certificat_propriete','engagement','exemple_projet'
                ];
                $labels = [
                    '1- نسخة من كراس الشروط','2- الاصل من شهادة ايداع التصريح','3- فاتورة','4- عقد بين المشتري و المورد','5- وثيقة الاعلام بالوصول',
                    '6- وثيقة الشحن','7- نسخة من بطاقة التعريف الجبائي','8- نسخة من مضمون السجل الوطني للمؤسسات','9- نسخة من شهادة الملكية',
                    '10- تعهد','11- مثال هندسي للمشروع'
                ];
            @endphp

            @foreach($files as $index => $file)
                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ $labels[$index] }}</label>
                    <div class="col-sm-6">
                        @if(!empty($document->$file))
                            <a href="{{ asset('storage/'.$document->$file) }}" target="_blank" class="btn btn-link">مشاهدة الملف</a>
                        @else
                            <span>-</span>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>

     
		<div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                  <button type="button" onclick="window.print()" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-print"></i> طباعة
                </button>
                <a href="{{ route('admin.exoneration.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
       
    </form>
</div>

@else
<script>
    window.location.href = "{{ route('login') }}";
</script>
@endif
@endsection
