@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.exoneration.update', $document->id_doc) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
      
        <h3 style="font-size:25px;">{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;padding-top:20px;">إستمارة تسجيل الإنتفاع بإعفاء جبائي</h4>
        <br>
        <div class="card shadow-lg border-0 mb-4 rounded-4">
            <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
                @if($document->id_statut == 1)
                    <span class="status-badge status-badge--success">موافقة </span>
                @elseif($document->id_statut == 3)
                    <span class="status-badge status-badge--danger">عدم موافقة</span>
                @elseif($document->id_statut == 4)
                    <span class="status-badge status-badge--pending">موافقة شريطة</span>
                @elseif($document->id_statut == 5)
                    <span class="status-badge status-badge--pending">ارجاء لابداء الراي</span>
                @else
                    <span class="status-badge status-badge--pending">في الانتظار</span>
                @endif
            </div>
            <div class="card-body">
                <p class="text-muted mb-4 text-center fs-6">
                    إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:
                </p>
                   <div class="form-group row align-items-center mb-3">
      <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
      <div class="col-sm-4">
        <select class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInputActivite()">
          <option value="">اختر...</option>
          @foreach($statuts as $s)
            @php
              $statutId = $s->id_statut ?? $s->id ?? $s->ID;
              if (in_array($statutId, [2,6])) continue; // hide pending & draft
              $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
              $selected = (string) old('id_statut', $document->id_statut ?? '') === (string) $statutId;
            @endphp
            <option value="{{ $statutId }}" {{ $selected ? 'selected' : '' }}>
              {{ $label }}
            </option>
          @endforeach
        </select>
      </div>
    </div>
               <div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق">
	</textarea>
</div>

{{-- reject textarea shown only when status == 3 --}}
<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
    <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض">
	</textarea>
</div>
            </div>
        </div>
		<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5>
  </div>

  <div class="card-body p-2" dir="rtl">
    @if($document->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($document->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to   = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>       
	   <br>
        <div class="form-section">
            <h4>هوية صاحب المشروع</h4>

            <div class="form-group row mb-3" style="padding-top:20px;">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_prenom" maxlength="50"
                           value="{{ old('nom_prenom', $document->utilisateur->nom_prenom) }}">
                </div>

                <label class="col-sm-2 col-form-label"> رقم الهاتف </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="tel"
                           value="{{ old('tel', $document->utilisateur->tel) }}">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput4()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" {{ $document->utilisateur->id_type_identite == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="{{ $document->utilisateur->cin ? '' : 'display:none;' }}">
                    <input type="text" class="form-control" id="cin_input" name="cin" placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8"
                           value="{{ old('cin', $document->utilisateur->cin) }}">
                </div>
                <div class="col-sm-6" id="passport_field" style="{{ $document->utilisateur->passport ? '' : 'display:none;' }}">
                    <input type="text" class="form-control" id="passport_input" name="passport" placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12"
                           value="{{ old('passport', $document->utilisateur->passport) }}">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="{{ $document->utilisateur->num_fiscal ? '' : 'display:none;' }}">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12"
                           value="{{ old('num_fiscal', $document->utilisateur->num_fiscal) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="adresse" maxlength="50"
                           value="{{ old('adresse', $document->utilisateur->adresse) }}">
                </div>

                <label class="col-sm-2 col-form-label"> البريد الالكتروني </label>
                <div class="col-sm-4">
                    <input required type="email" class="form-control" name="email"
                           value="{{ old('email', $document->utilisateur->email) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عنوان المشروع  </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet"
                           value="{{ old('nom_projet', $document->nom_projet) }}">
                </div>

                <label class="col-sm-2 col-form-label"> مكان المشروع </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="adresse_projet"
                           value="{{ old('adresse_projet', $document->adresse_projet) }}">
                </div>
            </div>

        </div>

        <div class="form-section mt-4">
            <h4> إضافة الوثائق المطلوبة </h4>

            @php
                $files = [
                    'copie_cahier_des_charges','copie_originale','facture','contrat','fichier_arrivage','fichier_colisage',
                    'copie_registre_fiscal','copie_registre_national_institutions','copie_certificat_propriete','engagement','exemple_projet'
                ];
                $labels = [
                    '1- نسخة من كراس الشروط','2- الاصل من شهادة ايداع التصريح','3- فاتورة','4- عقد بين المشتري و المورد','5- وثيقة الاعلام بالوصول',
                    '6- وثيقة الشحن','7- نسخة من بطاقة التعريف الجبائي','8- نسخة من مضمون السجل الوطني للمؤسسات','9- نسخة من شهادة الملكية',
                    '10- تعهد','11- مثال هندسي للمشروع'
                ];
            @endphp

            @foreach($files as $index => $file)
                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ $labels[$index] }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" name="{{ $file }}">
                        @if(!empty($document->$file))
                            <a href="{{ asset('storage/'.$document->$file) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
                        @endif
                    </div>
                </div>
            @endforeach

        </div>
 <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="{{ route('admin.exoneration.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
       
    </form>
</div>

@else
<script>
    window.location.href = "{{ route('login') }}";
</script>
@endif
@endsection
