@extends('backoffice.dashboard')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <form method="POST" action="{{ route('types.store') }}" enctype="multipart/form-data">
                    @csrf

                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">إضافة قائمة رئيسية</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">

                            <div class="form-group">
                                <label>الاسم (عربي) <span class="text-danger">*</span></label>
                                <input name="type_ar" class="form-control" value="{{ old('type_ar') }}" required>
                            </div>

                            <div class="form-group">
                                <label>الاسم (Français)</label>
                                <input name="type_fr" class="form-control" value="{{ old('type_fr') }}">
                            </div>

                            <div class="form-group">
                                <label>الاسم (English)</label>
                                <input name="type_en" class="form-control" value="{{ old('type_en') }}">
                            </div>

                        </div>

                        <div class="block-card-footer mt-3 mb-3 text-center">
                            <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-save mr-1"></i> حفظ
                            </button>
                            <a href="{{ route('types.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-times mr-1"></i> إلغاء
                            </a>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
</section>
</div>

@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif

@endsection
