@extends('backoffice.dashboard')
@section('content')
<style>
    .btn-success-custom {
        background-color: green;
        color: white;
    }

    .btn-success-custom i { color: white; }

    .btn-orange {
        background-color: orange;
        color: white;
    }

    .btn-orange i { color: white; }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0"> إدارة القوائم</h2>
                    <a class="btn btn-success font-weight-medium" href="{{ route('guides.create') }}">
                        <i class="la la-plus mr-1"></i> إضافة
                    </a>
                </div>
				
				<div class="block-card-header px-4 border-bottom-0 pb-3">
					<form method="GET" action="{{ route('guides.index') }}">
						<div class="form-row align-items-center" style="direction: rtl;">
							<div class="col-auto" style="width: 250px;">
								<input
									type="text"
									class="form-control"
									name="search"
									placeholder="بحث بالعربية أو الفرنسية أو الإنقليزية"
									value="{{ request('search') }}"
								>
							</div>

							<div class="col d-flex">
								<button type="submit"
										class="btn bg-rgb-primary1 font-weight-medium"
										style="width: 105px;">
									بحث
								</button>

								<a href="{{ route('guides.index') }}"
								   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
								   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
									<i class="fa-solid fa-rotate-right"></i>
								</a>
							</div>
						</div>
					</form>
				</div>



                 <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                <thead class="thead-light">
                    <tr>
                        <th>المعرف</th>
                                    <th>العنوان بالعربية</th>
                                    <th>العنوان بالفرنسية</th>
                                    <th>العنوان بالانقليزية</th>
                                    <th>نوع القائمة</th>
                                    <th>الترتيب</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($guides as $index => $guide)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $guide->titre_G }}</td>
                                        <td>{{ $guide->titre_fr }}</td>
                                        <td>{{ $guide->titre_en }}</td>
                                        <td>
                                            @if($guide->type == 'menu_principal')
                                                <span>قائمة رئيسية</span>
                                            @elseif($guide->type == 'sous_menu')
                                                <span >قائمة فرعية</span>
                                            @else
                                                <span>غير محدد</span>
                                            @endif
                                        </td>
                                        <td>{{ $guide->ordre }}</td>
                                      <td class="text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                                            <a class="btn-icon btn-icon--warning" title="تعديل" href="{{ route('guides.edit', $guide->id_G) }}"
                                               >
                                                <i class="la la-edit"></i>
                                            </a>

                                            <form action="{{ route('guides.destroy', $guide->id_G) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button"  class="btn-icon btn-icon--danger"
                                          title="حذف"
                                                        onclick="confirmDelete(this.closest('form'))">
                                                    <i class="la la-trash"></i>
                                                </button>
                                            </form>
</div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد دلائل حاليا</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                  
							 <div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $guides->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- SweetAlert functions -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    function confirmEdit(url) {
        Swal.fire({
            icon: 'question',
            title: 'هل تريد حقًا تعديل هذا الدليل؟',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء',
            reverseButtons: true,
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-primary mx-2',
                cancelButton: 'btn btn-secondary'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    function confirmDelete(form) {
        Swal.fire({
            icon: 'warning',
            title: 'هل تريد حذف هذا الدليل؟',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء',
            reverseButtons: true,
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger mx-2',
                cancelButton: 'btn btn-secondary'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }
</script>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>

@endsection
