@extends('backoffice.dashboard')

@section('content')

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">وثائق التمويل العمومي (اللجنة الفنية ) </h2>
                    
                </div>

<div class="block-card-header px-4 border-bottom-0 pb-0">
    <form method="GET" action="{{ route('admin.doc_fin2.index') }}">
        <div class="form-row align-items-center">

            <div class="col-auto" style="width: 220px;">
                <select id="search-option" class="form-control" name="search_option"
                        onchange="showSearchInput(this.value)">
                    <option value="">اختر نوع البحث</option>
                    <option value="association" {{ request('search_option') == 'association' ? 'selected' : '' }}>
                        إسم الجمعية
                    </option>
                    <option value="demande" {{ request('search_option') == 'demande' ? 'selected' : '' }}>
                        طلب في التمويل العمومي
                    </option>
                    <option value="projet" {{ request('search_option') == 'projet' ? 'selected' : '' }}>
                        اسم المشروع / التظاهرة / النشاط
                    </option>
                    <option value="superviseur" {{ request('search_option') == 'superviseur' ? 'selected' : '' }}>
                        اسم و لقب المشرف على التنفيذ
                    </option>
                </select>
            </div>

            <div class="col-auto search-field" id="searchByAssociation" style="width:220px; display:none;">
                <input type="text" class="form-control" name="nom_association"
                       placeholder="إسم الجمعية"
                       value="{{ request('nom_association') }}">
            </div>

            <div class="col-auto search-field" id="searchByDemande" style="width:220px; display:none;">
				<select class="form-control" name="type_demande">
					<option value="">-- اختر نوع التمويل --</option>
					@foreach($type_financement as $type)
						<option value="{{ $type->id_type_fin }}"
							{{ request('type_demande') == $type->id_type_fin ? 'selected' : '' }}>
							{{ $type->type_ar }}
						</option>
					@endforeach
				</select>
			</div>



            <div class="col-auto search-field" id="searchByProjet" style="width:220px; display:none;">
                <input type="text" class="form-control" name="nom_projet"
                       placeholder="اسم المشروع / التظاهرة / النشاط"
                       value="{{ request('nom_projet') }}">
            </div>

            <div class="col-auto search-field" id="searchBySuperviseur" style="width:220px; display:none;">
                <input type="text" class="form-control" name="nom_superviseur"
                       placeholder="اسم و لقب المشرف على التنفيذ"
                       value="{{ request('nom_superviseur') }}">
            </div>

            <div class="col d-flex">
                <button type="submit"
                        class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                        style="width:105px;">
                    بحث
                </button>

                <a href="{{ route('admin.doc_fin2.index') }}"
                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                   style="width:45px; height:38px; margin-right:5px; padding:0;">
                    <i class="fa-solid fa-rotate-right"></i>
                </a>
            </div>

        </div>
    </form>
</div>

                 <div class="block-card-body">          @if(session('success'))           
                     <div class="alert alert-success alert-dismissible fade show" role="alert">   
                                   {{ session('success') }}             
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>   
                                         </div>          
                                         @endif         
                                          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
                                            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">                <thead class="thead-light">                    <tr>                        <th>المعرف</th>
                                    <th>إسم المشروع</th>
                                    <th>الحالة</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($documents as $index => $doc)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $doc->projet?->nom_projet ?? '---' }}</td>
                                    <td>
                                        <span class="status-badge 
                                            {{ $doc->id_statut2 == 1 ? 'status-badge--success' : ($doc->id_statut2 == 3 ? 'status-badge--danger' : 'status-badge--pending') }}">
                                            {{ $doc->statut2?->statut_ar ?? 'في الانتظار' }}
                                        </span>
                                    </td>

                                  <td class="text-center">        
                                        <div class="d-flex flex-wrap gap-2 justify-content-center">
                                        <a  class="btn-icon btn-icon--info" title="عرض" href="{{ route('admin.doc_fin2.show', $doc->id_doc_list) }}">
                                            <i class="la la-eye"></i>
                                        </a>

                                        @if($doc->id_statut2 == 2 || $doc->id_statut2 == 4 || $doc->id_statut2 == 5)
                                            <a class="btn-icon btn-icon--warning" title="تعديل" href="{{ route('admin.doc_fin2.edit', $doc->id_doc_list) }}"
										
												>
                                                <i class="la la-edit"></i>
                                            </a>


                                            <form action="{{ route('admin.doc_fin2.toggle_statut', $doc->id_doc_list) }}" 
                                                method="POST" 
                                                class="form-modifier-statut mr-2" 
                                                style="display:inline;">
                                                @csrf
                                                @method('PATCH')
                                                <button type="button" 
                                                        onclick="confirmStatusChange6(this.closest('form'), '{{ $doc->statut2?->statut_ar }}')" 
                                                       class="btn-icon btn-icon--secondary"                                              title="تغيير الحالة" aria-label="تغيير الحالة">
                                                    <i class="la la-toggle-on"></i> 
                                                </button>

                                            </form>


                                            <form action="{{ route('admin.doc_fin2.destroy', $doc->id_doc_list) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" 
                                                        onclick="confirmDelete(this.closest('form'))" 
                                                         class="btn-icon btn-icon--danger"                                          title="حذف">
                                                    <i class="la la-trash"></i> 
                                                </button>

                                            </form>

                                        @endif</div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center">لا توجد وثائق حالياً</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                   <div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $documents->links('pagination::bootstrap-5') }}
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<script>
    function confirmEdit(url) {
    Swal.fire({
        icon: 'question',
        title: 'هل تريد حقًا تعديل هذه الوثيقة؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-primary mx-2',
            cancelButton: 'btn btn-secondary'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = url; 
        }
    });
}

function confirmDelete(form) {
    Swal.fire({
        icon: 'warning',
        title: 'هل تريد حذف هذه الوثيقة؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-danger mx-2',
            cancelButton: 'btn btn-secondary'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        }
    });
}


</script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    function showSearchInput(selected) {
        selected = (selected || "").trim();

        const fields = [
            "searchByAssociation",
            "searchByDemande",
            "searchByProjet",
            "searchBySuperviseur"
        ];

        // Tout masquer
        fields.forEach(id => {
            const el = document.getElementById(id);
            if (el) el.style.display = "none";
        });

        // Afficher selon le choix
        if (selected && document.getElementById("searchBy" + capitalize(selected))) {
            document.getElementById("searchBy" + capitalize(selected)).style.display = "block";
        }
    }

    // Fonction utilitaire
    function capitalize(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    }

    // Appliquer dès le chargement
    const selectedOption = "{{ trim(request('search_option')) }}";
    showSearchInput(selectedOption);

    // Réagir au changement du select
    document.getElementById("search-option").addEventListener("change", function () {
        showSearchInput(this.value);
    });
});
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

@endsection
