@extends('backoffice.dashboard')

@section('content')
<style>
    .btn-success-custom { background-color: green; color: white; }
    .btn-success-custom i, .btn-orange i { color: white; }
    .btn-orange { background-color: orange; color: white; }
</style>

@if(Auth::check())
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">
        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
          <h2 class="widget-title pb-0">قائمة طلبات المسابقة الخارجية</h2>

        </div>

{{-- Zone de recherche --}}
<div class="block-card-header px-4 border-bottom-0 pb-3">
    <form method="GET" action="{{ route('concours_ext.index', $concours->id) }}">
        <div class="form-row align-items-center" style="direction: rtl;">
            <div class="col-auto" style="width: 250px;">
                <input 
                    type="text" 
                    class="form-control" 
                    name="q" 
                    placeholder="البحث بالاسم أو cin أو email"
                    value="{{ request('q') }}"
                >
            </div>

            <div class="col d-flex">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                    بحث
                </button>
                <a href="{{ route('concours_ext.index', $concours->id) }}"
                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                    <i class="fa-solid fa-rotate-right"></i>
                </a>
            </div>
        </div>
    </form>
</div>

        <div class="block-card-body">
            @if(session('success')) <div class="alert alert-success text-end">{{ session('success') }}</div> @endif
          @if(session('error')) <div class="alert alert-danger text-end">{{ session('error') }}</div> @endif

       <div class="my-table table-responsive">
            <table class="table align-items-center table-flush mb-0">
              <thead class="thead-light">
  <tr>
    <th>الاسم</th>
    <th>CIN</th>
    <th>الهاتف</th>
    <th>البريد</th>
    <th>تاريخ الإنشاء</th>
    <th>الحالة</th> {{-- new status column --}}
    <th style="width:220px">إجراءات</th>
  </tr>
</thead>
<tbody>
  @forelse($candidates as $c)
    <tr>
      <td>{{ $c->nom }} {{ $c->prenom }}</td>
      <td>{{ $c->cin }}</td>
      <td>{{ $c->tel }}</td>
      <td>{{ $c->email }}</td>
      <td>{{ optional($c->created_at)->format('Y-m-d H:i') }}</td>

      <td class="text-center">
        @php $s = $c->etat ?? 'en_cours'; @endphp
        <span class="status-badge status-badge--success" >{{ $statusOptions[$s] ?? $s }}</span>
      </td>

      <td>
        <div class="d-flex justify-content-end gap-2">
    {{-- Show --}}
<a href="{{ route('concours_ext.show', ['concours' => $concours->id, 'candidate' => $c->id]) }}"
  class="btn-icon btn-icon--primary" title="عرض">
  <i class="la la-eye"></i></a>

{{-- Destroy --}}
<form method="POST"
      action="{{ route('concours_ext.destroy', ['concours' => $concours->id, 'candidate' => $c->id]) }}"
      onsubmit="return confirm('هل أنت متأكد من الحذف؟');" style="display:inline;">
  @csrf @method('DELETE')
  <button  class="btn-icon btn-icon--danger" title="حذف">
     <i class="la la-trash"></i>
	 </button>
</form>

        </div>
      </td>
    </tr>
  @empty
    <tr><td colspan="7" class="text-center p-4">لا توجد طلبات حتى الآن.</td></tr>
  @endforelse
</tbody>
            </table>
          </div>

   
<div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $candidates->links('pagination::bootstrap-5') }}
                    </div>
        </div>


        </div>

      </div>
    </div>
  </div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection
