@extends('backoffice.dashboard')

@section('content')
<style>
    .btn-success-custom { background-color: green; color: white; }
    .btn-success-custom i, .btn-orange i { color: white; }
    .btn-orange { background-color: orange; color: white; }
</style>

@if(Auth::check())
<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">
        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
    
           <h2 class="widget-title pb-0">قائمة حقول المسابقة (ديناميكية)</h2>
       <a href="{{ route('backoffice.field_definitions.create') }}" class="btn btn-primary">حقل جديد</a>
        </div>

<div class="block-card-header px-4 border-bottom-0 pb-0"> 

</div>
        <div class="block-card-body">
          @if(session('ok'))
            <div class="alert alert-success">{{ session('ok') }}</div>
          @endif

  <div class="my-table table-responsive">
            <table class="table align-items-center table-flush mb-0">
              <thead class="thead-light">
        <tr>
          {{-- <th style="width:70px">#</th> --}}
          {{-- <th>المفتاح (key)</th> --}}
          <th>الوسم (label)</th>
          <th>نوع الإدخال</th>
          <th>خيارات</th>
          <th>مرئي</th>
          <th>مطلوب</th>
          <th >إجراءات</th>
        </tr>
      </thead>
      <tbody>
        @foreach($definitions as $d)
          <tr>
            {{-- <td>{{ $d->sort_order }}</td> --}}
            {{-- <td>{{ $d->key }}</td> --}}
            <td>{{ $d->label }}</td>
            <td>{{ $d->input_type }}</td>
            <td>
              @if($d->options())
                <ul class="mb-0">
                  @foreach($d->options() as $opt)
                    <li>{{ $opt }}</li>
                  @endforeach
                </ul>
              @endif
            </td>
            <td>
              <form action="{{ route('backoffice.field_definitions.toggleVisibility', $d) }}" method="POST" style="display:inline;">
                @csrf
                <button class="btn btn-sm {{ $d->is_visible ? 'btn-outline-success' : 'btn-outline-secondary' }}">
                  {{ $d->is_visible ? 'ظاهر' : 'مخفي' }}
                </button>
              </form>
            </td>
            <td>{{ $d->is_required ? 'نعم' : 'لا' }}</td>
            <td>
              <div class="d-flex gap-2 justify-content-end">
                <a href="{{ route('backoffice.field_definitions.edit', $d) }}" class="btn btn-sm btn-outline-secondary">تعديل</a>
<form action="{{ route('backoffice.field_definitions.destroy', $d) }}"
      method="POST"
      style="display:inline;"
      id="delete-field-{{ $d->id }}">
    @csrf @method('DELETE')
    <button type="button" class="btn btn-sm btn-danger"
            onclick="confirmAction('هل تريد حذف هذا الحقل؟ هذا قد يحذف بيانات مرتبطة.', null, document.getElementById('delete-field-{{ $d->id }}'))">
      حذف
    </button>
</form>
              </div>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>


        </div>

      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-news th, 
.table-news td {
    vertical-align: middle;
    text-align: center;
}

.table-news th:nth-child(2),
.table-news td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    color: #fff;
    min-width: 60px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.status-badge--success {
    background-color: #e8f9ee; 
    color: #27ae60;           
}

.status-badge--danger {
    background-color: #fde8ea; 
    color: #e74c3c;            
}


</style>
@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection
