@extends('backoffice.dashboard')

@section('content')
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="block-card mb-4">
                    <div class="block-card-header">
              <div class="text-end">
            <h2 class="widget-title">تعديل الطلب #{{ $concours_ext->id }}</h2>
            <div class="stroke-shape"></div>
          </div>
          {{-- <div class="text-start">
            <a href="{{ route('concours_ext.index') }}" class="btn btn-sm btn-outline-secondary">العودة</a>
          </div> --}}
        </div>

        <div class="card-body">
          @if($errors->any())
            <div class="alert alert-danger text-end"><ul class="mb-0">@foreach($errors->all() as $err)<li>{{ $err }}</li>@endforeach</ul></div>
          @endif

          <form action="{{ route('concours_ext.update', $concours_ext) }}" method="POST" enctype="multipart/form-data" novalidate>
            @csrf @method('PUT')

            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">اللقب *</label>
                <input name="nom" class="form-control" value="{{ old('nom', $concours_ext->nom) }}" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">الاسم الشخصي *</label>
                <input name="prenom" class="form-control" value="{{ old('prenom', $concours_ext->prenom) }}" required>
              </div>

              <div class="col-md-4">
                <label class="form-label">CIN</label>
                <input name="cin" class="form-control" value="{{ old('cin', $concours_ext->cin) }}">
              </div>

              <div class="col-md-4">
                <label class="form-label">تاريخ الازدياد</label>
                <input name="date_naissance" type="date" class="form-control" value="{{ old('date_naissance', $concours_ext->date_naissance) }}">
              </div>

              <div class="col-md-4">
                <label class="form-label">الهاتف</label>
                <input name="tel" class="form-control" value="{{ old('tel', $concours_ext->tel) }}">
              </div>

              <div class="col-md-6">
                <label class="form-label">البريد</label>
                <input name="email" type="email" class="form-control" value="{{ old('email', $concours_ext->email) }}">
              </div>

              <div class="col-md-6">
                <label class="form-label">الولاية</label>
                <input name="gouvernorat" class="form-control" value="{{ old('gouvernorat', $concours_ext->gouvernorat) }}">
              </div>

              <div class="col-12">
                <label class="form-label">العنوان</label>
                <textarea name="adresse" rows="2" class="form-control">{{ old('adresse', $concours_ext->adresse) }}</textarea>
              </div>

              <div class="col-md-4">
                <label class="form-label">الرمز البريدي</label>
                <input name="code_postale" class="form-control" value="{{ old('code_postale', $concours_ext->code_postale) }}">
              </div>
            </div>

            {{-- <hr class="my-4"> --}}

            {{-- <h5 class="text-end mb-3">الحقول الديناميكية</h5> --}}

            <div class="row g-3">
              @foreach($fieldDefinitions as $def)
                @php
                  $inputName = 'field_'.$def->id;
                  $value = old($inputName, $prefill[$inputName] ?? null);
                  $label = $def->label ?: $def->key;
                  $isRequired = $def->is_required;
                @endphp

                <div class="col-md-6">
                  <label class="form-label">{{ $label }} @if($isRequired) <span class="text-danger">*</span> @endif</label>

                  @switch($def->input_type)
                    @case('textarea')
                      <textarea name="{{ $inputName }}" class="form-control">{{ $value }}</textarea>
                      @break

                    @case('date')
                      <input name="{{ $inputName }}" type="date" class="form-control" value="{{ $value }}">
                      @break

                    @case('number')
                      <input name="{{ $inputName }}" type="number" step="any" class="form-control" value="{{ $value }}">
                      @break

                    @case('file')
                      <input name="{{ $inputName }}" type="file" class="form-control">
                      @break

                    @case('email')
                      <input name="{{ $inputName }}" type="email" class="form-control" value="{{ $value }}">
                      @break

                    @default
                      <input name="{{ $inputName }}" type="text" class="form-control" value="{{ $value }}">
                  @endswitch
                </div>
              @endforeach
            </div>

            <div class="mt-4 d-flex justify-content-start">
              <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-save mr-1">حفظ</i>
                            </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</section>
@endsection
