@extends('backoffice.dashboard')

@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
<div class="container py-4" dir="rtl" lang="ar">
  <div class="row justify-content-center">
    <div class="col-lg-12">
      <div class="card shadow-sm">
        <div class="card-header text-center bg-white">
          <h4 class="mb-0">{{ $method === 'create' ? 'إنشاء مناظرة جديدة' : 'تعديل مناظرة' }}</h4>
        </div>

        <div class="card-body">
          @if($errors->any())
            <div class="alert alert-danger text-end">
              <ul class="mb-0">
                @foreach($errors->all() as $err) <li>{{ $err }}</li> @endforeach
              </ul>
            </div>
          @endif

          <form method="POST"
                action="{{ $method === 'create' ? route('concours.store') : route('concours.update', $concours) }}"
                novalidate>
            @csrf
            @if($method === 'edit') @method('PUT') @endif

            {{-- Basic concours meta --}}
            <div class="mb-3 text-end">
            <label class="form-label"> العنوان بالعربية<span class="text-danger">*</span></label>
            <input name="titre_ar" value="{{ old('titre_ar', $concours->titre_ar) }}" class="form-control" required>
			<label class="form-label"> العنوان بالفرنسية<span class="text-danger">*</span></label>
            <input name="titre_fr" value="{{ old('titre_fr', $concours->titre_fr) }}" class="form-control" required>
			<label class="form-label"> العنوان بالانجليزية<span class="text-danger">*</span></label>
            <input name="titre_en" value="{{ old('titre_en', $concours->titre_en) }}" class="form-control" required>

            </div>

            <div class="row g-2 mb-3">
              <div class="col-md-4 text-end">
                <label class="form-label">تاريخ البداية</label>
                <input name="date_debut" type="date" class="form-control"
                       value="{{ old('date_debut', optional($concours->date_debut)->format('Y-m-d')) }}">
              </div>
              <div class="col-md-4 text-end">
                <label class="form-label">تاريخ الانتهاء</label>
                <input name="date_fin" type="date" class="form-control"
                       value="{{ old('date_fin', optional($concours->date_fin)->format('Y-m-d')) }}">
              </div>
			   <div class="col-md-4 text-end">
			     <label class="form-label">الحالة</label>
              <select name="etat" class="form-control">
                <option value="draft" {{ old('etat', $concours->etat) === 'draft' ? 'selected' : '' }}>مسودة</option>
                <option value="published" {{ old('etat', $concours->etat) === 'published' ? 'selected' : '' }}>منشور</option>
                <option value="closed" {{ old('etat', $concours->etat) === 'closed' ? 'selected' : '' }}>مغلق</option>
              </select>
			   </div>
            </div>

           

            {{-- Core columns --}}
            {{-- Core columns --}}
            @php
              $coreCols = [
                'nom' => 'اللقب / الاسم العائلي',
                'prenom' => 'الاسم الشخصي',
                'cin' => 'رقم بطاقة التعريف',
                'date_naissance' => 'تاريخ الولادة',
                'tel' => 'الهاتف',
                'email' => 'البريد الإلكتروني',
                'adresse' => 'العنوان',
                'gouvernorat' => 'الولاية',
                'code_postale' => 'الرمز البريدي',
              ];
              $enabledCore = old('core_fields', $concours->core_fields ?? []);
              $requiredCore = old('core_required', $concours->core_required ?? []);
            @endphp

            <div class="mb-3">
              <label class="form-label d-block text-end">الحقول الأساسية</label>
  <div class="form-text text-muted text-end mt-1">هذه حقول ثابتة تُعرض دائماً في نموذج الترشيح.</div>
             <div class="row gx-2 gy-2">
    @foreach($coreCols as $key => $label)
      <div class="col-12 col-md-4">
        <div class="core-field-item d-flex align-items-center justify-content-between p-2">
          <div class="text-end">
            <div class="fw-medium">{{ $label }}</div>
          </div>
        </div>

        @if(in_array($key, (array)$enabledCore))
          <input type="hidden" name="core_fields[]" value="{{ $key }}">
        @endif

        @if(in_array($key, (array)$requiredCore))
          <input type="hidden" name="core_required[]" value="{{ $key }}">
        @endif
      </div>
    @endforeach
</div>


            
            </div>

{{-- Attached fields --}}
<div class="mb-4">
  <label class="form-label d-block text-end">الحقول الخاصة بهذه المناظرة</label>

  <div id="attachedFieldsBar" class="container-fluid px-0">
    @if($fields->isEmpty())
      <div class="text-muted small">لا توجد حقول مرفقة بعد.</div>
    @else
      {{-- chunk into groups of 2 so there are exactly two cards per row --}}
      @foreach($fields->chunk(2) as $pair)
        <div class="row g-2">
          @foreach($pair as $field)
            <div class="col-12 col-md-6">
              <div class="d-flex align-items-center border rounded px-3 py-2 attached-field-card" data-field-row="{{ $field->id }}">
                <input type="hidden" name="fields[]" value="{{ $field->id }}" data-attached-id="{{ $field->id }}">

                <div class="me-3 text-end" style="min-width:160px;">
                  <div class="fw-medium field-label-text">{{ $field->label }}</div>
                  <small class="text-muted">({{ $field->input_type }})</small>
                </div>

                <div class="ms-auto d-flex gap-1 align-items-center">
                  <button type="button" class="btn btn-sm btn-outline-secondary edit-field-btn" data-field-id="{{ $field->id }}">تعديل</button>
                 
                  <button type="button" class="btn btn-sm btn-outline-danger delete-db-field-btn" data-field-id="{{ $field->id }}">حذف</button>
                </div>
              </div>
            </div>
          @endforeach

          {{-- if this chunk has only one item, keep an empty col to preserve layout --}}
          @if($pair->count() === 1)
            <div class="col-12 col-md-6"></div>
          @endif
        </div>

        {{-- render edit panels right after the row (each panel is full width) --}}
        @foreach($pair as $field)
          <div class="row">
            <div class="col-12">
              <div class="card mt-2 p-2 d-none edit-panel" data-edit-panel-for="{{ $field->id }}">
                <div class="row g-2">
                  <div class="col-md-6">
                    <label class="form-label"> التسمية </label>
                    <input type="text" class="form-control edit-field-label" placeholder="التسمية" value="{{ $field->label }}">
                  </div>

                  <div class="col-md-6">
                    <label class="form-label"> نوع الحقل</label>
                    <select class="form-control edit-field-type">
                      <option value="text" {{ $field->input_type === 'text' ? 'selected' : '' }}>نص</option>
                      <option value="textarea" {{ $field->input_type === 'textarea' ? 'selected' : '' }}>منطقة نص</option>
                      <option value="date" {{ $field->input_type === 'date' ? 'selected' : '' }}>تاريخ</option>
                      <option value="number" {{ $field->input_type === 'number' ? 'selected' : '' }}>رقم</option>
                      <option value="select" {{ $field->input_type === 'select' ? 'selected' : '' }}>قائمة</option>
                      <option value="radio" {{ $field->input_type === 'radio' ? 'selected' : '' }}>راديو</option>
                      <option value="checkbox" {{ $field->input_type === 'checkbox' ? 'selected' : '' }}>مربعات اختيار</option>
                      <option value="file" {{ $field->input_type === 'file' ? 'selected' : '' }}>ملف</option>
                      <option value="email" {{ $field->input_type === 'email' ? 'selected' : '' }}>بريد إلكتروني</option>
                    </select>
                  </div>

                  <div class="col-md-6 text-end d-flex align-items-center gap-2">
                    <div class="form-check form-check-inline">
                      <input class="form-check-input edit-field-visible" type="checkbox" id="edit_visible_{{ $field->id }}" {{ $field->is_visible ? 'checked' : '' }}>
                      <label class="form-check-label small" for="edit_visible_{{ $field->id }}">معروض</label>
                    </div>

                    <div class="form-check form-check-inline">
                      <input class="form-check-input edit-field-required" type="checkbox" id="edit_required_{{ $field->id }}" {{ $field->is_required ? 'checked' : '' }}>
                      <label class="form-check-label small" for="edit_required_{{ $field->id }}">إلزامي</label>
                    </div>
                  </div>

                  @php
                    $editOptions = method_exists($field, 'options') ? $field->options() : [];
                    $showWrapper = in_array($field->input_type, ['select','radio','checkbox']) || !empty($editOptions);
                  @endphp

                  <div class="col-12">
                    <div class="options-table-wrapper {{ $showWrapper ? '' : 'd-none' }}">
                      <table class="table table-sm options-table mb-0">
                        <thead>
                          <tr>
                            <th class="text-end">الخيار</th>
                            <th style="width:90px" class="text-center">العمليات</th>
                          </tr>
                        </thead>
                        <tbody>
                          @if(!empty($editOptions))
                            @foreach($editOptions as $opt)
                              <tr>
                                <td class="text-end">
                                  <input type="text" class="form-control form-control-sm edit-option-input" value="{{ $opt }}">
                                </td>
                                <td class="text-center">
                                  <div class="d-flex gap-1 justify-content-center">
                                    <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn">×</button>
                                    <button type="button" class="btn btn-sm btn-outline-success add-option-btn">+</button>
                                  </div>
                                </td>
                              </tr>
                            @endforeach
                          @else
                            <tr>
                              <td class="text-end"><input type="text" class="form-control form-control-sm edit-option-input" value=""></td>
                              <td class="text-center">
                                <div class="d-flex gap-1 justify-content-center">
                                  <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn">×</button>
                                  <button type="button" class="btn btn-sm btn-outline-success add-option-btn">+</button>
                                </div>
                              </td>
                            </tr>
                          @endif
                        </tbody>
                      </table>
                    </div>
                  </div>

                  <div class="col-12">
                    <div class="d-flex justify-content-between w-100" style="direction:ltr;">
                      <button type="button" class="btn btn-sm btn-outline-secondary cancel-edit-field-btn" data-field-id="{{ $field->id }}">إلغاء</button>
                      <button type="button" class="btn btn-sm btn-primary save-edit-field-btn" data-field-id="{{ $field->id }}">حفظ التعديل</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        @endforeach
      @endforeach
    @endif
  </div>

  {{-- <div class="form-text text-muted text-end mt-2">يمكنك تعديل الحقول المرتبطة بهذه المسابقة أو حذفها أو اضافه حقول جديدة.</div> --}}
</div>



            {{-- New fields widget --}}
            <div class="mb-4">
              <h6 class="mb-2 text-end">إنشاء حقل جديد</h6>

              <div id="newFieldsContainer" class="mb-2">
                {{-- restore old inputs (if any) --}}
                @if(old('new_fields'))
                  @foreach(old('new_fields') as $i => $nf)
                    @php
                      $type = $nf['input_type'] ?? 'text';
                      $showOptions = in_array($type, ['select','radio','checkbox']);
                      $is_visible = isset($nf['is_visible']) ? (int)$nf['is_visible'] === 1 : 1;
                      $is_required = isset($nf['is_required']) ? (int)$nf['is_required'] === 1 : 0;
                      // options may be string or array
                      $optsArr = [];
                      if (isset($nf['options'])) {
                        if (is_array($nf['options'])) $optsArr = $nf['options'];
                        else $optsArr = preg_split('/\r\n|\n|\r|,/', (string)$nf['options']);
                        $optsArr = array_values(array_filter(array_map('trim', $optsArr)));
                      }
                    @endphp

                    <div class="card mb-2 p-2 new-field-row">
                      <div class="d-flex gap-2 align-items-start" style="direction:rtl;">
                        <div class="flex-grow-1">
                          <div class="mb-2">
                             <label class="form-label"> التسمية </label>
                            <input type="text" name="new_fields[{{ $i }}][label]" class="form-control form-control-sm" placeholder="التسمية (العنوان)" value="{{ $nf['label'] ?? '' }}">
                          </div>

                          <div class="row g-2 align-items-center">
                            
                            <div class="col-md-5">
                                <label class="form-label"> نوع الحقل</label>
                              <select name="new_fields[{{ $i }}][input_type]" class="form-control">
                                <option value="text" {{ $type === 'text' ? 'selected' : '' }}>نص</option>
                                <option value="textarea" {{ $type === 'textarea' ? 'selected' : '' }}>منطقة نص</option>
                                <option value="date" {{ $type === 'date' ? 'selected' : '' }}>تاريخ</option>
                                <option value="number" {{ $type === 'number' ? 'selected' : '' }}>رقم</option>
                                <option value="select" {{ $type === 'select' ? 'selected' : '' }}>قائمة</option>
                                <option value="radio" {{ $type === 'radio' ? 'selected' : '' }}>اختيار موحد</option>
                                <option value="checkbox" {{ $type === 'checkbox' ? 'selected' : '' }}>اختيارات متعددة </option>
                                <option value="file" {{ $type === 'file' ? 'selected' : '' }}>ملف</option>
                                <option value="email" {{ $type === 'email' ? 'selected' : '' }}>بريد إلكتروني</option>
                              </select>
                            </div>

                            <div class="col-md-7 text-end d-flex gap-2">
                              <input type="hidden" name="new_fields[{{ $i }}][is_visible]" value="0">
                              <div class="form-check form-check-inline">
                                <input class="form-check-input new-field-visible" type="checkbox" name="new_fields[{{ $i }}][is_visible]" id="nf_vis_{{ $i }}" value="1" {{ $is_visible ? 'checked' : '' }}>
                                <label class="form-check-label small" for="nf_vis_{{ $i }}">معروض</label>
                              </div>

                              <input type="hidden" name="new_fields[{{ $i }}][is_required]" value="0">
                              <div class="form-check form-check-inline">
                                <input class="form-check-input new-field-required" type="checkbox" name="new_fields[{{ $i }}][is_required]" id="nf_req_{{ $i }}" value="1" {{ $is_required ? 'checked' : '' }}>
                                <label class="form-check-label small" for="nf_req_{{ $i }}">إلزامي</label>
                              </div>
                            </div>
                          </div>

                          {{-- dynamic options table --}}
                          <div class="mt-2 new-field-options" style="{{ $showOptions ? '' : 'display:none;' }}">
                            <table class="table table-sm mb-1 options-table">
                              <thead>
                                <tr>
                                  <th class="text-end">الخيار</th>
                                  <th style="width:90px" class="text-center">العمليات</th>
                                </tr>
                              </thead>
                              <tbody>
                                @if(!empty($optsArr))
                                  @foreach($optsArr as $opt)
                                    <tr>
                                      <td class="text-end"><input type="text" name="new_fields[{{ $i }}][options][]" class="form-control form-control-sm option-input" value="{{ $opt }}"></td>
                                      <td class="text-center">
                                        <div class="d-flex gap-1 justify-content-center">
                                          <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn">×</button>
                                          <button type="button" class="btn btn-sm btn-outline-success add-option-btn">+</button>
                                        </div>
                                      </td>
                                    </tr>
                                  @endforeach
                                @else
                                  <tr>
                                    <td class="text-end"><input type="text" name="new_fields[{{ $i }}][options][]" class="form-control form-control-sm option-input" value=""></td>
                                    <td class="text-center">
                                      <div class="d-flex gap-1 justify-content-center">
                                        <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn">×</button>
                                        <button type="button" class="btn btn-sm btn-outline-success add-option-btn">+</button>
                                      </div>
                                    </td>
                                  </tr>
                                @endif
                              </tbody>
                            </table>
                          </div>

                        </div>

                        <div style="width:64px; display:flex; align-items:center; justify-content:center;">
                          <button type="button" class="btn btn-sm btn-outline-danger remove-new-field">حذف</button>
                        </div>
                      </div>
                    </div>
                  @endforeach
                @endif
              </div>

              <div class="text-end">
                <button type="button" id="addNewFieldBtn" class="btn btn-sm btn-outline-success">+ إضافة حقل جديد</button>
              </div>

            </div>

            <div id="dynamicHiddenInputs"></div>

          
			   <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> {{ $method === 'create' ? 'إنشاء' : 'حفظ التغييرات' }}
                </button>
                <a href="{{ route('concours.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Delete confirmation modal -->
<div class="modal fade" id="confirmDeleteModal" tabindex="-1" aria-labelledby="confirmDeleteModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" dir="rtl">
    <div class="modal-content text-end">
      <div class="modal-header">
        <h5 class="modal-title" id="confirmDeleteModalLabel">تأكيد الحذف</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
      </div>
      <div class="modal-body">
        <p class="mb-2">هل أنت متأكد من حذف هذا الحقل نهائياً من قاعدة البيانات؟</p>
        <div class="fw-semibold" id="confirmDeleteModalFieldLabel" style="word-break:break-word;"></div>
        <input type="hidden" id="confirmDeleteModalFieldId" value="">
        <div id="confirmDeleteModalError" class="text-danger small mt-2 d-none"></div>
      </div>
      <div class="modal-footer">
        <button type="button" id="confirmDeleteCancelBtn" class="btn btn-outline-secondary" data-bs-dismiss="modal">إلغاء</button>
        <button type="button" id="confirmDeleteConfirmBtn" class="btn btn-danger">
          <span id="confirmDeleteConfirmBtnText">حذف</span>
          <span id="confirmDeleteConfirmBtnSpinner" class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>
        </button>
      </div>
    </div>
  </div>
</div>

@push('styles')
<style>
  .card { border-radius: 12px; }
  .new-field-row { background: #fff; border:1px solid #eef2f6; border-radius:8px; }
  .form-label { font-weight:600; }
  .fw-medium { font-weight:600; }
  .edit-panel { background:#fafafa; border:1px solid #eef2f6; border-radius:6px; }
  .options-table input { text-align: right; }
  .options-table th { border-bottom: none; }
  .options-table td { vertical-align: middle; }
  .options-table .btn { min-width:34px; padding-left:.4rem; padding-right:.4rem; }
  .attached-field-card { min-height: 64px; }
@media (min-width: 768px) {
  #attachedFieldsBar .col-md-6 { padding-left: .5rem; padding-right: .5rem; }
}
/* Core fields — simple, clean presentation (RTL-friendly) */
.core-field-item {
  border: 1px solid #e9eef3;
  background: #ffffff;
  border-radius: 8px;
  min-height: 56px;
}

.core-field-item .fw-medium {
  font-weight: 600;
  font-size: 0.98rem;
}

/* small status labels (not "badges") */
.core-field-flag {
  display: inline-block;
  font-size: 0.82rem;
  padding: 4px 8px;
  border-radius: 6px;
  background: #f6f8fa;
  color: #2b2f33;
  box-shadow: none;
}

/* subtle colors for states */
.core-field-enabled { background: #e9f7ee; color: #0b6b3a; } /* greenish for enabled */
.core-field-disabled { background: #fff8e6; color: #6a5800; } /* amber for not shown */
.core-field-required { background: #ffeef0; color: #8a1f2d; } /* reddish for required */

</style>
@endpush

@push('scripts')


<script>
(function() {
  function $(q, ctx=document){ return ctx.querySelector(q); }
  function $all(q, ctx=document){ return Array.from((ctx||document).querySelectorAll(q)); }

  const hiddenHolder = document.getElementById('dynamicHiddenInputs');
  const newFieldsContainer = document.getElementById('newFieldsContainer');
  const addNewFieldBtn = document.getElementById('addNewFieldBtn');

  function addHiddenInput(name, value) {
    const i = document.createElement('input');
    i.type = 'hidden'; i.name = name; i.value = value;
    hiddenHolder.appendChild(i);
    return i;
  }

  function escapeHtml(s){ return String(s || '').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;'); }

  // ------------ Edit-panel helpers (attached fields) ------------
  function createEditOptionRow(value = '') {
    const tr = document.createElement('tr');
    tr.innerHTML = `<td class="text-end"><input type="text" class="form-control form-control-sm edit-option-input" value="${escapeHtml(value)}"></td>
                    <td class="text-center">
                      <div class="d-flex gap-1 justify-content-center">
                        <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn">×</button>
                        <button type="button" class="btn btn-sm btn-outline-success add-option-btn">+</button>
                      </div>
                    </td>`;
    // remove
    tr.querySelector('.remove-option-btn').addEventListener('click', function(e){ e.stopPropagation(); tr.remove(); });
    // add: insert after current and stop propagation so delegated handlers won't duplicate
    tr.querySelector('.add-option-btn').addEventListener('click', function(e){ e.stopPropagation(); tr.after(createEditOptionRow('')); });
    return tr;
  }

  function toggleEditPanelOptions(panel) {
    const type = panel.querySelector('.edit-field-type').value;
    const wrapper = panel.querySelector('.options-table-wrapper');
    if (['select','radio','checkbox'].includes(type)) wrapper.classList.remove('d-none'); else wrapper.classList.add('d-none');
  }

  function addOptionRowToEditTbody(tbody, value='') {
    const tr = createEditOptionRow(value);
    tbody.appendChild(tr);
    return tr;
  }
// Ensure option rows in the edit panel have working handlers (safe to call repeatedly)
function initOptionRowsForPanel(panel) {
  if (!panel) return;
  const optWrapper = panel.querySelector('.options-table-wrapper');
  if (!optWrapper) return;
  const tbody = optWrapper.querySelector('tbody');
  // if wrapper should be visible (server rendered options), ensure it's shown
  // and attach handlers for existing rows without double-binding
  if (!tbody) return;

  // If wrapper has rows, attach handlers for each row (use cloning to avoid double binding)
  Array.from(tbody.querySelectorAll('tr')).forEach(tr => {
    const removeBtn = tr.querySelector('.remove-option-btn');
    const addBtn = tr.querySelector('.add-option-btn');

    if (removeBtn) {
      const cloneRemove = removeBtn.cloneNode(true);
      removeBtn.replaceWith(cloneRemove);
      cloneRemove.addEventListener('click', function(e){ e.stopPropagation(); tr.remove(); });
    }

    if (addBtn) {
      const cloneAdd = addBtn.cloneNode(true);
      addBtn.replaceWith(cloneAdd);
      cloneAdd.addEventListener('click', function(e){
        e.stopPropagation();
        // insert a new row after current row using same structure
        const newTr = createEditOptionRow('');
        tr.after(newTr);
      });
    }
  });

  // If wrapper is visible but has no rows, add a blank one so admin sees something to edit
  if (!optWrapper.classList.contains('d-none') && tbody.children.length === 0) {
    addOptionRowToEditTbody(tbody, '');
  }
}

  // Attach listeners for attached field controls
  function attachControlListeners() {
    $all('[data-field-row]').forEach(row => {
      const fid = row.getAttribute('data-field-row');
      const panel = document.querySelector('.edit-panel[data-edit-panel-for="'+fid+'"]');

      // edit toggle
row.querySelectorAll('.edit-field-btn').forEach(b => b.addEventListener('click', function(){
  if (!panel) return;

  // toggle panel visibility
  panel.classList.toggle('d-none');

  // make wrapper visibility reflect the current selected type
  toggleEditPanelOptions(panel);

  // initialize option rows & handlers for this panel now it's visible
  initOptionRowsForPanel(panel);

  if (!panel.classList.contains('d-none')) panel.scrollIntoView({behavior:'smooth', block:'center'});
}));


 


      if (!panel) return;

      // toggle options when type changes
      const typeSelect = panel.querySelector('.edit-field-type');
      typeSelect && typeSelect.addEventListener('change', ()=> toggleEditPanelOptions(panel));

      // init option rows handlers for existing rows: ensure each remove/add button works
      const optWrapper = panel.querySelector('.options-table-wrapper');
      if (optWrapper) {
        const tbody = optWrapper.querySelector('tbody');
        // convert existing rows to have working handlers (avoid duplicate listeners)
        Array.from(tbody.querySelectorAll('tr')).forEach(tr => {
          const oldRemove = tr.querySelector('.remove-option-btn');
          const oldAdd = tr.querySelector('.add-option-btn');
          if (oldRemove) {
            const clone = oldRemove.cloneNode(true);
            oldRemove.replaceWith(clone);
            clone.addEventListener('click', function(e){ e.stopPropagation(); tr.remove(); });
          }
          if (oldAdd) {
            const clone2 = oldAdd.cloneNode(true);
            oldAdd.replaceWith(clone2);
            clone2.addEventListener('click', function(e){ e.stopPropagation(); tr.after(createEditOptionRow('')); });
          }
        });

        // if there are no rows and options visible, add one
        if (tbody.children.length === 0 && !optWrapper.classList.contains('d-none')) {
          addOptionRowToEditTbody(tbody, '');
        }
      }

      // Save edit -> create hidden edit_fields[...] inputs
      const saveBtn = panel.querySelector('.save-edit-field-btn');
      saveBtn && saveBtn.addEventListener('click', function(){
        const newLabel = panel.querySelector('.edit-field-label').value.trim();
        const newType = panel.querySelector('.edit-field-type').value;
        const visible = panel.querySelector('.edit-field-visible').checked ? '1' : '0';
        const required = panel.querySelector('.edit-field-required').checked ? '1' : '0';

        // remove previous edit inputs for this id
        $all('input[name^="edit_fields['+fid+']"], textarea[name^="edit_fields['+fid+']"]').forEach(n => n.remove());

        addHiddenInput('edit_fields['+fid+'][label]', newLabel);
        addHiddenInput('edit_fields['+fid+'][input_type]', newType);
        addHiddenInput('edit_fields['+fid+'][is_visible]', visible);
        addHiddenInput('edit_fields['+fid+'][is_required]', required);

        // collect options (if visible)
        const options = [];
        const optWrapperLocal = panel.querySelector('.options-table-wrapper');
        if (optWrapperLocal && !optWrapperLocal.classList.contains('d-none')) {
          optWrapperLocal.querySelectorAll('.edit-option-input').forEach(inp => {
            const v = inp.value.trim();
            if (v !== '') options.push(v);
          });
        }

        if (options.length) {
          options.forEach(o => addHiddenInput('edit_fields['+fid+'][options][]', o));
        }

        // update label text on the badge
        const labelTextEl = row.querySelector('.field-label-text');
        if (labelTextEl) labelTextEl.textContent = newLabel;

        panel.classList.add('d-none');
      });

      // cancel
      const cancelBtn = panel.querySelector('.cancel-edit-field-btn');
      cancelBtn && cancelBtn.addEventListener('click', ()=> panel.classList.add('d-none'));
    });
  }

  // ------- New fields helpers -------
  function createNewOptionRowElement(nameTemplate, value='') {
    const tr = document.createElement('tr');
    tr.innerHTML = `<td class="text-end"><input type="text" name="${nameTemplate}" class="form-control form-control-sm option-input" value="${escapeHtml(value)}"></td>
                    <td class="text-center">
                      <div class="d-flex gap-1 justify-content-center">
                        <button type="button" class="btn btn-sm btn-outline-danger remove-option-btn">×</button>
                        <button type="button" class="btn btn-sm btn-outline-success add-option-btn">+</button>
                      </div>
                    </td>`;
    // remove
    tr.querySelector('.remove-option-btn').addEventListener('click', function(e){ e.stopPropagation(); tr.remove(); });
    // add: insert after this row and stop propagation to prevent delegated duplicate handler
    tr.querySelector('.add-option-btn').addEventListener('click', function(e){ e.stopPropagation(); const newTr = createNewOptionRowElement(nameTemplate, ''); tr.after(newTr); });
    return tr;
  }

  function addNewOptionRow(tbody, nameTemplate, value='') {
    const tr = createNewOptionRowElement(nameTemplate, value);
    tbody.appendChild(tr);
    return tr;
  }

  function initNewFieldsWidget() {
    if (!newFieldsContainer || !addNewFieldBtn) return;

function makeRow(idx, preset = null) {
  const div = document.createElement('div');
  div.className = 'card mb-2 p-2 new-field-row';

  // unique ids for select + options wrapper
  div.innerHTML = `
    <div style="direction:rtl;">
      <div class="d-flex gap-2">
        <div class="flex-grow-1">
          <div class="row g-2 align-items-center">
            <div class="col-md-6">
              <label class="form-label">التسمية</label>
              <input type="text" name="new_fields[${idx}][label]" class="form-control form-control-sm" placeholder="التسمية (العنوان)">
            </div>

            <div class="col-md-6">
              <label class="form-label">نوع الحقل</label>
              <select id="new-field-type-${idx}" name="new_fields[${idx}][input_type]" class="form-control">
                <option value="text">نص</option>
                <option value="textarea">منطقة نص</option>
                <option value="date">تاريخ</option>
                <option value="number">رقم</option>
                <option value="select">قائمة</option>
                <option value="radio">راديو</option>
                <option value="checkbox">مربعات اختيار</option>
                <option value="file">ملف</option>
                <option value="email">بريد إلكتروني</option>
              </select>
            </div>
          </div>

          <div class="row g-2 mt-2 align-items-center">
              <div class="col-md-6 text-end">
              <!-- hidden fallback + visible checkbox for is_visible -->
              <input type="hidden" name="new_fields[${idx}][is_visible]" value="0">
              <div class="form-check form-check-inline">
                <input class="form-control new-field-visible" type="checkbox" name="new_fields[${idx}][is_visible]" id="nf_vis_${idx}" value="1" checked>
                <label class="form-label" for="nf_vis_${idx}">معروض</label>
              </div>

              <!-- hidden fallback + visible checkbox for is_required -->
              <input type="hidden" name="new_fields[${idx}][is_required]" value="0">
              <div class="form-check form-check-inline">
                <input class="form-control new-field-required" type="checkbox" name="new_fields[${idx}][is_required]" id="nf_req_${idx}" value="1">
                <label class="form-label" for="nf_req_${idx}">إلزامي</label>
              </div>
            </div>
            <div class="col-md-6">
              <!-- options area (hidden until needed) -->
              <div id="new-field-options-${idx}" class="mt-2 new-field-options" style="display:none;">
                <table class="table table-bordered options-table">
                  <thead class="thead-light">
                    <tr>
                      <th class="text-end">الخيار</th>
                      <th style="width:90px" class="text-center">العمليات</th>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
              </div>
            </div>

          
          </div>
        </div>

        <!-- spacer for remove button column -->
        <div style="width:64px;"></div>
      </div>

      <!-- remove button (positioning handled by your CSS) -->
      <button type="button" class="btn btn-sm btn-outline-danger remove-new-field">حذف</button>
    </div>
  `;

  // initialize elements & events after insert
  setTimeout(()=> {
    const typeSelect = document.getElementById(`new-field-type-${idx}`);
    const optionsDiv = document.getElementById(`new-field-options-${idx}`);
    const tbody = optionsDiv.querySelector('tbody');

    // prefill options if preset provided
    if (preset && Array.isArray(preset.options) && preset.options.length) {
      preset.options.forEach(o => addNewOptionRow(tbody, `new_fields[${idx}][options][]`, o));
      optionsDiv.style.display = '';
      if (preset.input_type) typeSelect.value = preset.input_type;
      // preset.checked states (if present) — accept '1' or true
      const visCb = div.querySelector('.new-field-visible');
      const reqCb = div.querySelector('.new-field-required');
      if (typeof preset.is_visible !== 'undefined') visCb.checked = Boolean(Number(preset.is_visible) || preset.is_visible === true);
      if (typeof preset.is_required !== 'undefined') reqCb.checked = Boolean(Number(preset.is_required) || preset.is_required === true);
    }

    // toggle options area when type changes
    typeSelect.addEventListener('change', function() {
      if (['select','radio','checkbox'].includes(this.value)) {
        optionsDiv.style.display = '';
        if (tbody.children.length === 0) addNewOptionRow(tbody, `new_fields[${idx}][options][]`, '');
      } else {
        optionsDiv.style.display = 'none';
        tbody.innerHTML = '';
      }
    });

    // remove-new-field
    const removeBtn = div.querySelector('.remove-new-field');
    removeBtn && removeBtn.addEventListener('click', ()=> { div.remove(); reindexNewFields(); });

    // ensure at least one option row when needed
    if (preset && ['select','radio','checkbox'].includes(typeSelect.value) && tbody.children.length === 0) {
      addNewOptionRow(tbody, `new_fields[${idx}][options][]`, '');
    }
  }, 0);

  return div;
}


    function reindexNewFields() {
      Array.from(newFieldsContainer.querySelectorAll('.new-field-row')).forEach((r, i) => {
        r.querySelectorAll('input[name],select[name]').forEach(el => {
          const name = el.getAttribute('name');
          if (!name) return;
          el.setAttribute('name', name.replace(/new_fields\[\d+\]/g, `new_fields[${i}]`));
        });
        // reindex options inputs inside table
        r.querySelectorAll('.option-input').forEach(inp => {
          const name = inp.getAttribute('name') || '';
          inp.setAttribute('name', name.replace(/new_fields\[\d+\]\[options\]\[\]/g, `new_fields[${i}][options][]`));
        });
      });
    }

    addNewFieldBtn.addEventListener('click', function(e){
      e.preventDefault();
      const idx = newFieldsContainer.querySelectorAll('.new-field-row').length;
      const row = makeRow(idx);
      newFieldsContainer.appendChild(row);
      row.scrollIntoView({behavior:'smooth', block:'center'});
    });

    // delegated handler for clicks inside newFieldsContainer (manage remove option and remove-row only)
    // NOTE: add-option is handled by per-row listener which calls e.stopPropagation() to prevent duplication.
    newFieldsContainer.addEventListener('click', function(ev){
      const t = ev.target;
      if (!t || !t.classList) return;

      // remove new field
      if (t.classList.contains('remove-new-field')) {
        const row = t.closest('.new-field-row');
        if (row) { row.remove(); reindexNewFields(); }
        return;
      }

      // remove option (delegated as fallback)
      if (t.classList.contains('remove-option-btn')) {
        const tr = t.closest('tr'); if (tr) tr.remove();
        return;
      }

      // If add-option is clicked but didn't have per-row handler (fallback), handle here.
      if (t.classList.contains('add-option-btn')) {
        // ensure it wasn't stopped by per-row handler
        const rowCard = t.closest('.new-field-row');
        if (!rowCard) return;
        const optionsDiv = rowCard.querySelector('.new-field-options');
        if (!optionsDiv) return;
        const tbody = optionsDiv.querySelector('tbody');
        const idx = Array.from(newFieldsContainer.querySelectorAll('.new-field-row')).indexOf(rowCard);
        // fallback insertion at end of tbody
        addNewOptionRow(tbody, `new_fields[${idx}][options][]`, '');
        reindexNewFields();
        return;
      }
    });

    // On load: for server-rendered rows ensure options area behavior and attach proper handlers
// On load: for server-rendered rows ensure options area behavior and attach proper handlers
Array.from(newFieldsContainer.querySelectorAll('.new-field-row')).forEach((r, idx) => {
  // ensure the row's select and options wrapper have stable ids
  let typeSelect = r.querySelector('select[name$="[input_type]"]');
  if (typeSelect && !typeSelect.id) {
    typeSelect.id = `new-field-type-${idx}`;
  }
  let optionsDiv = r.querySelector('.new-field-options');
  if (optionsDiv && !optionsDiv.id) {
    optionsDiv.id = `new-field-options-${idx}`;
  }

  // ensure option inputs' name attributes include the correct index
  const tbody = optionsDiv && optionsDiv.querySelector('tbody');
  if (tbody) {
    tbody.querySelectorAll('.option-input').forEach(inp => {
      const currentName = inp.getAttribute('name') || `new_fields[${idx}][options][]`;
      inp.setAttribute('name', currentName.replace(/new_fields\[\d+\]\[options\]\[\]/g, `new_fields[${idx}][options][]`));
    });

    // attach add/remove handlers for each row's option controls (avoid double-binding)
    Array.from(tbody.querySelectorAll('tr')).forEach(tr => {
      const oldRemove = tr.querySelector('.remove-option-btn');
      const oldAdd = tr.querySelector('.add-option-btn');
      if (oldRemove) {
        const clone = oldRemove.cloneNode(true);
        oldRemove.replaceWith(clone);
        clone.addEventListener('click', function(e){ e.stopPropagation(); tr.remove(); });
      }
      if (oldAdd) {
        const clone2 = oldAdd.cloneNode(true);
        oldAdd.replaceWith(clone2);
        clone2.addEventListener('click', function(e){
          e.stopPropagation();
          const newTr = createNewOptionRowElement(`new_fields[${idx}][options][]`, '');
          tr.after(newTr);
          reindexNewFields();
        });
      }
    });
  }

  // attach change listener (by id) to toggle options area
  typeSelect = document.getElementById(`new-field-type-${idx}`);
  optionsDiv = document.getElementById(`new-field-options-${idx}`);
  if (typeSelect && optionsDiv) {
    typeSelect.addEventListener('change', function(){
      if (['select','radio','checkbox'].includes(this.value)) {
        optionsDiv.style.display = '';
        const tbodyLocal = optionsDiv.querySelector('tbody');
        if (tbodyLocal && tbodyLocal.children.length === 0) addNewOptionRow(tbodyLocal, `new_fields[${idx}][options][]`, '');
      } else {
        optionsDiv.style.display = 'none';
        const tbodyLocal = optionsDiv.querySelector('tbody');
        if (tbodyLocal) tbodyLocal.innerHTML = '';
      }
    });

    // Make visibility consistent for server-rendered rows: show if it already contains rows
    const tbodyLocal = optionsDiv.querySelector('tbody');
    if (tbodyLocal && tbodyLocal.children.length > 0) {
      optionsDiv.style.display = '';
    } else {
      // if the select is a multi-choice type, ensure at least one row
      if (['select','radio','checkbox'].includes(typeSelect.value) && tbodyLocal && tbodyLocal.children.length === 0) {
        addNewOptionRow(tbodyLocal, `new_fields[${idx}][options][]`, '');
        optionsDiv.style.display = '';
      }
    }
  }

  // ensure remove button works for server-rendered rows
  const removeBtn = r.querySelector('.remove-new-field');
  if (removeBtn) {
    removeBtn.addEventListener('click', function(){
      r.remove();
      reindexNewFields();
    });
  }
});

  }

  // init
 document.addEventListener('DOMContentLoaded', function(){
  attachControlListeners();
  initNewFieldsWidget();

  // ensure all edit-panels get their option rows wired (so stored rows are usable even before opening)
  document.querySelectorAll('.edit-panel').forEach(panel => {
    // ensure wrapper visibility matches current select value (in case backend made it visible)
    toggleEditPanelOptions(panel);
    // attach handlers to existing rows and create a blank row if needed
    initOptionRowsForPanel(panel);
  });
});

})();
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  const form = document.querySelector('form');
  if (!form) return;

  function collectNewFieldsAsPayload() {
    const rows = Array.from(document.querySelectorAll('.new-field-row'));
    const payload = rows.map((row, idx) => {
      const labelEl = row.querySelector('input[name^="new_fields"][name$="[label]"]');
      const typeEl  = row.querySelector('select[name^="new_fields"][name$="[input_type]"]');
    
      // prefer the visible checkbox (not the hidden fallback input). If no checkbox found, use the first matching element.
function firstNonHidden(selector, ctx) {
  const els = Array.from((ctx||document).querySelectorAll(selector));
  if (els.length === 0) return null;
  const cb = els.find(e => e.type !== 'hidden');
  return cb || els[0];
}

const visEl = firstNonHidden('input[name^="new_fields"][name$="[is_visible]"]', row);
const reqEl = firstNonHidden('input[name^="new_fields"][name$="[is_required]"]', row);

      const opts = Array.from(row.querySelectorAll('.option-input'))
                        .map(i => (i.value || '').trim())
                        .filter(v => v !== '');

      return {
        label: labelEl ? (labelEl.value || '').trim() : '',
        input_type: typeEl ? (typeEl.value || 'text') : 'text',
     is_visible: (visEl && (visEl.type === 'checkbox' ? visEl.checked : (visEl.value === '1'))) ? '1' : '0',
is_required: (reqEl && (reqEl.type === 'checkbox' ? reqEl.checked : (reqEl.value === '1'))) ? '1' : '0',

        options: opts
      };
    });

    // attach / update hidden input carrying JSON payload
    let hidden = document.getElementById('new_fields_payload_input');
    if (!hidden) {
      hidden = document.createElement('input');
      hidden.type = 'hidden';
      hidden.id = 'new_fields_payload_input';
      hidden.name = 'new_fields_payload';
      form.appendChild(hidden);
    }
    hidden.value = JSON.stringify(payload);
  }

  // before submit: reindex names (if you keep that logic) and then build payload
  form.addEventListener('submit', function (ev) {
    try {
      // keep your existing reindex function if present
      if (typeof window.reindexNewFields === 'function') window.reindexNewFields();
    } catch (e) { /* ignore */ }

    // now build the payload that the server will prefer
    collectNewFieldsAsPayload();
    // form continues to submit normally
  });
});
</script>

{{-- ensure CSRF meta exists (usually in your layout) --}}
<meta name="csrf-token" content="{{ csrf_token() }}">

<script>
(function(){
  // Blade will render something like "/field-definitions/__FID__"
  const destroyUrlTemplate = "{!! route('backoffice.field_definitions.destroy', ['fieldDefinition' => '__FID__']) !!}";

  function getCsrf() {
    const m = document.querySelector('meta[name="csrf-token"]');
    return m ? m.getAttribute('content') : '';
  }

  // Helper: remove UI for a field id
  function removeFieldRowAndPanel(fid) {
    const row = document.querySelector('[data-field-row="'+fid+'"]');
    if (row) row.remove();
    const panel = document.querySelector('.edit-panel[data-edit-panel-for="'+fid+'"]');
    if (panel) panel.remove();
  }

  // Send delete request (DELETE then fallback to POST with _method=DELETE)
  async function sendDeleteRequest(fid) {
    const url = destroyUrlTemplate.replace('__FID__', encodeURIComponent(fid));

    let resp = await fetch(url, {
      method: 'DELETE',
      headers: {
        'X-CSRF-TOKEN': getCsrf(),
        'Accept': 'application/json',
        'X-Requested-With': 'XMLHttpRequest'
      },
      credentials: 'same-origin'
    });

    if (resp.status === 405 || resp.status === 419) {
      resp = await fetch(url, {
        method: 'POST',
        headers: {
          'X-CSRF-TOKEN': getCsrf(),
          'Accept': 'application/json',
          'X-Requested-With': 'XMLHttpRequest',
          'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
        },
        credentials: 'same-origin',
        body: new URLSearchParams({ _method: 'DELETE' }).toString()
      });
    }

    return resp;
  }

  // --- modal plumbing ---
  const modalEl = document.getElementById('confirmDeleteModal');
  if (!modalEl) {
    console.error('confirmDeleteModal element not found. Make sure the modal HTML exists with id="confirmDeleteModal".');
  }

  // elements inside modal (expected)
  const fieldLabelEl = modalEl ? modalEl.querySelector('#confirmDeleteModalFieldLabel') : null;
  const fieldIdInput = modalEl ? modalEl.querySelector('#confirmDeleteModalFieldId') : null;
  const confirmBtn = modalEl ? modalEl.querySelector('#confirmDeleteConfirmBtn') : null;
  const confirmBtnSpinner = modalEl ? modalEl.querySelector('#confirmDeleteConfirmBtnSpinner') : null;
  const errorEl = modalEl ? modalEl.querySelector('#confirmDeleteModalError') : null;
  const cancelBtn = modalEl ? modalEl.querySelector('#confirmDeleteCancelBtn') : null;
  const closeBtn = modalEl ? modalEl.querySelector('.btn-close') : null;

  // detect bootstrap JS
  const hasBootstrap = (typeof bootstrap !== 'undefined' && bootstrap && typeof bootstrap.Modal !== 'undefined');

  // fallback modal state
  let backdropEl = null;
  let escHandler = null;

  function showModalFallback() {
    if (!modalEl) return;
    backdropEl = document.createElement('div');
    backdropEl.className = 'modal-backdrop fade show';
    document.body.appendChild(backdropEl);

    modalEl.style.display = 'block';
    modalEl.classList.add('show');
    modalEl.removeAttribute('aria-hidden');
    modalEl.setAttribute('aria-modal', 'true');
    document.body.classList.add('modal-open');

    backdropEl.addEventListener('click', hideModalFallback);
    escHandler = function(e){
      if (e.key === 'Escape') hideModalFallback();
    };
    document.addEventListener('keydown', escHandler);
  }

  function hideModalFallback() {
    if (!modalEl) return;
    modalEl.classList.remove('show');
    modalEl.style.display = 'none';
    modalEl.setAttribute('aria-hidden', 'true');
    modalEl.removeAttribute('aria-modal');
    if (backdropEl && backdropEl.parentNode) backdropEl.parentNode.removeChild(backdropEl);
    backdropEl = null;
    document.body.classList.remove('modal-open');
    if (escHandler) {
      document.removeEventListener('keydown', escHandler);
      escHandler = null;
    }
  }

  // unified show/hide functions (use bootstrap if available otherwise fallback)
  let bsModalInstance = null;
  function showModal() {
    if (!modalEl) return;
    if (hasBootstrap) {
      bsModalInstance = bootstrap.Modal.getOrCreateInstance(modalEl);
      bsModalInstance.show();
    } else {
      showModalFallback();
    }
  }
  function hideModal() {
    if (!modalEl) return;
    if (hasBootstrap && bsModalInstance) {
      try { bsModalInstance.hide(); } catch(e){ /* ignore */ }
    } else {
      hideModalFallback();
    }
  }

  // helper to set busy spinner on confirm button
  function setModalBusy(isBusy) {
    if (!confirmBtn) return;
    confirmBtn.disabled = !!isBusy;
    if (confirmBtnSpinner) {
      if (isBusy) confirmBtnSpinner.classList.remove('d-none');
      else confirmBtnSpinner.classList.add('d-none');
    }
  }

  // --- user feedback helpers (no alert on success) ---
  // Try to use Bootstrap Toast if available; otherwise use a simple inline alert that auto-hides.
  function ensureToastContainer() {
    let c = document.getElementById('globalToastContainer');
    if (!c) {
      c = document.createElement('div');
      c.id = 'globalToastContainer';
      // place at top-right of viewport
      c.style.position = 'fixed';
      c.style.zIndex = 10850;
      c.style.top = '1rem';
      c.style.right = '1rem';
      document.body.appendChild(c);
    }
    return c;
  }

  function showSuccess(message) {
    if (!message) message = 'تم الحذف.';
    if (hasBootstrap && typeof bootstrap.Toast !== 'undefined') {
      const container = ensureToastContainer();
      const toastEl = document.createElement('div');
      toastEl.className = 'toast align-items-center text-bg-success border-0';
      toastEl.setAttribute('role', 'alert');
      toastEl.setAttribute('aria-live', 'polite');
      toastEl.setAttribute('aria-atomic', 'true');
      toastEl.innerHTML = `
        <div class="d-flex">
          <div class="toast-body">${escapeHtmlForAttr(message)}</div>
          <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
      `;
      container.appendChild(toastEl);
      const toast = new bootstrap.Toast(toastEl, { delay: 3000 });
      toast.show();
      // remove after hidden
      toastEl.addEventListener('hidden.bs.toast', () => toastEl.remove());
      return;
    }

    // fallback: inline transient alert at top of form (or body if form not found)
    let container = document.querySelector('.card-body');
    if (!container) container = document.body;
    const alert = document.createElement('div');
    alert.className = 'alert alert-success alert-dismissible fade show';
    alert.setAttribute('role', 'alert');
    alert.style.marginTop = '0.5rem';
    alert.innerHTML = `
      ${escapeHtmlForAttr(message)}
      <button type="button" class="btn-close" aria-label="Close"></button>
    `;
    container.insertBefore(alert, container.firstChild);
    const closeBtn = alert.querySelector('.btn-close');
    if (closeBtn) closeBtn.addEventListener('click', () => alert.remove());
    // auto remove
    setTimeout(() => {
      alert.classList.remove('show');
      try { alert.remove(); } catch(e){}
    }, 3000);
  }

  function showInfo(message) {
    // alias to showSuccess for now (different styling could be added)
    showSuccess(message);
  }

  // small helper to safely escape text inserted into element (not HTML)
  function escapeHtmlForAttr(s) {
    if (typeof s !== 'string') s = String(s || '');
    return s.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
  }

  // show modal for a given field id and optional label text
  function showModalForField(fid, labelText) {
    if (!fieldLabelEl || !fieldIdInput) return;
    fieldLabelEl.textContent = labelText || ('#' + fid);
    fieldIdInput.value = fid;
    if (errorEl) { errorEl.classList.add('d-none'); errorEl.textContent = ''; }
    setModalBusy(false);
    showModal();
  }

  // attach UI close handlers for fallback close buttons (close or cancel)
  function attachModalCloseButtons() {
    if (cancelBtn) cancelBtn.addEventListener('click', function(){ hideModal(); });
    if (closeBtn) closeBtn.addEventListener('click', function(){ hideModal(); });
    // also ensure if bootstrap modal hidden, reset spinner
    if (hasBootstrap && modalEl) {
      modalEl.addEventListener('hidden.bs.modal', function(){ setModalBusy(false); });
    }
  }

  // Attach delete button listeners
  function attachAjaxDeleteButtons() {
    document.querySelectorAll('.delete-db-field-btn').forEach(btn => {
      if (btn._deleteBound) return;
      btn._deleteBound = true;

      btn.addEventListener('click', function () {
        const fid = this.getAttribute('data-field-id');
        if (!fid) return;

        // try to get friendly label from the row
        let label = null;
        const row = document.querySelector('[data-field-row="'+fid+'"]');
        if (row) {
          const lab = row.querySelector('.field-label-text');
          if (lab) label = lab.textContent.trim();
        }

        showModalForField(fid, label);
      });
    });
  }

  // Confirm button handler
  async function onConfirmDeleteClick () {
    const fid = fieldIdInput ? fieldIdInput.value : null;
    if (!fid) return;
    setModalBusy(true);
    try {
      const resp = await sendDeleteRequest(fid);

      let json = null;
      try { json = await resp.json(); } catch(e){}

      if (resp.ok) {
        removeFieldRowAndPanel(fid);
        hideModal();
        // show non-alert success feedback (toast or inline)
        if (json && json.message) showSuccess(json.message);
        else showSuccess('تم حذف الحقل.');
        return;
      }

      // 404: already deleted -> remove UI and inform user (non-alert)
      if (resp.status === 404) {
        removeFieldRowAndPanel(fid);
        hideModal();
        showInfo((json && json.message) ? json.message : 'الحقل غير موجود (تم حذفه سابقاً).');
        return;
      }

      // other server error: fallback to queue deletion on form submit (hidden input)
      const hiddenHolder = document.getElementById('dynamicHiddenInputs');
      if (hiddenHolder) {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'delete_fields[]';
        input.value = fid;
        hiddenHolder.appendChild(input);
        removeFieldRowAndPanel(fid);
      }

      if (errorEl) {
        errorEl.classList.remove('d-none');
        errorEl.textContent = (json && json.message) ? json.message : 'حصل خطأ عند محاولة الحذف. تم إخفاء الحقل محلياً.';
      }

      // auto-hide after short delay so admin sees error
      setTimeout(hideModal, 900);
    } catch (err) {
      console.error('Delete request failed', err);
      // network error -> fallback to queue deletion and show inline message
      const hiddenHolder = document.getElementById('dynamicHiddenInputs');
      if (hiddenHolder) {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'delete_fields[]';
        input.value = fid;
        hiddenHolder.appendChild(input);
        removeFieldRowAndPanel(fid);
      }
      if (errorEl) {
        errorEl.classList.remove('d-none');
        errorEl.textContent = 'فشل الاتصال بالخادم — تم إخفاء الحقل محلياً وسيتم حذفه عند حفظ الاستمارة.';
      }
      setTimeout(hideModal, 900);
    } finally {
      setModalBusy(false);
    }
  }

  // hook confirm button
  function bindConfirmButton() {
    if (!confirmBtn) {
      console.error('confirm button not found inside modal (id="confirmDeleteConfirmBtn")');
      return;
    }
    // avoid duplicate binding
    if (confirmBtn._bound) return;
    confirmBtn._bound = true;
    confirmBtn.addEventListener('click', onConfirmDeleteClick);
  }

  // initialize on DOM ready
  document.addEventListener('DOMContentLoaded', function(){
    attachModalCloseButtons();
    attachAjaxDeleteButtons();
    bindConfirmButton();
    // Expose for dynamic re-binding if you re-render attached-fields area
    window.attachAjaxDeleteButtons = attachAjaxDeleteButtons;
  });

})();
</script>


@endpush

@stack('styles')
@stack('scripts')
@endsection
