@extends('backoffice.dashboard')

@section('title','تعديل صفحة')

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

<div class="container-fluid">
    <div class="block-card mb-4">
        <div class="block-card-header">
            <h2 class="widget-title"> تعديل الصفحة</h2>
            <div class="stroke-shape"></div>
        </div>

        <div class="block-card-body">

            <form action="{{ route('builder.update', $builder->id_builder) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <!-- TITRES -->
                <div class="form-group mb-3">
                    <label>العنوان بالعربية</label>
                    <input type="text" class="form-control" name="titre_ar" value="{{ $builder->titre_ar }}" required>
                </div>

                <div class="form-group mb-3">
                    <label>العنوان بالفرنسية</label>
                    <input type="text" class="form-control" name="titre_fr" value="{{ $builder->titre_fr }}">
                </div>

                <div class="form-group mb-3">
                    <label>العنوان بالإنجليزية</label>
                    <input type="text" class="form-control" name="titre_en" value="{{ $builder->titre_en }}">
                </div>

                <hr>

                <h4 class="mb-3">المحتوى</h4>

                <table class="table custom-table text-center" id="contenu-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>العرض (col)</th>
                            <th>النوع</th>
                            <th>المحتوى</th>
                            <th>إجراء</th>
                        </tr>
                    </thead>
                    <tbody id="contenu-body">
                        <!-- lignes dynamiques -->
                    </tbody>
                </table>

                <div class="block-card-footer mt-3 mb-3 text-center">
                    <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                        <i class="ri-save-line mr-1"></i> حفظ
                    </button>
                    <a href="{{ route('builder.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                        <i class="ri-close-line mr-1"></i> إلغاء
                    </a>
                </div>

            </form>
        </div>
    </div>
</div>

<!-- TEMPLATE LIGNE -->
<template id="row-template">
    <tr>
        <td class="row-number"></td>
        <input type="hidden" name="contenus[INDEX][id_builder_cont]" value="">
        <td>
            <select name="contenus[INDEX][col]" class="form-control">
                <option value="col-xl-12">12</option>
                <option value="col-xl-8">8</option>
                <option value="col-xl-6">6</option>
                <option value="col-xl-4">4</option>
                <option value="col-xl-3">3</option>
                <option value="col-xl-2">2</option>
            </select>
        </td>
        <td>
            <select name="contenus[INDEX][nature]" class="form-control nature-select" onchange="changeNature(this)">
                <option value="">اختيار</option>
                <option value="image">صورة</option>
                <option value="video">فيديو</option>
                <option value="texte">نص</option>
            </select>
        </td>
        <td class="contenu-column"></td>
        <td class="text-center">
            <button type="button" class="btn btn-success btn-sm me-1" onclick="addRow()">
                <i class="ri-add-line"></i>
            </button>
            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">
                <i class="ri-delete-bin-line"></i>
            </button>
        </td>
    </tr>
</template>

<!-- SCRIPTS -->
<script src="https://cdn.jsdelivr.net/npm/tinymce@6/tinymce.min.js"></script>
<script>
let index = 0;

function addRow(data = null) {
    let tpl = document.querySelector('#row-template').innerHTML;
    tpl = tpl.replace(/INDEX/g, index);
    const table = document.querySelector('#contenu-body');
    table.insertAdjacentHTML('beforeend', tpl);
    let row = table.querySelectorAll('tr')[table.querySelectorAll('tr').length - 1];

    if (data) {
        row.querySelector('input[name$="[id_builder_cont]"]').value = data.id_builder_cont;
        row.querySelector('select[name$="[col]"]').value = data.col;
        row.querySelector('select[name$="[nature]"]').value = data.nature;

        changeNature(row.querySelector('select[name$="[nature]"]'));

        if (data.nature === 'image' && data.image) {
            let url = `data:image/jpeg;base64,${data.image}`;
            row.querySelector('.contenu-column').innerHTML =
                `<img src="${url}" width="120" class="mt-2">` +
                `<input type="file" name="${row.querySelector('select[name$="[nature]"]').name.replace('[nature]','[image]')}" class="form-control mt-2">`;
        }

        if (data.nature === 'video') {
            row.querySelector('input[type="text"]').value = data.url_video;
        }

        if (data.nature === 'texte') {
            row.querySelector('textarea[name$="[text_ar]"]').value = data.text_ar;
            row.querySelector('textarea[name$="[text_fr]"]').value = data.text_fr;
            row.querySelector('textarea[name$="[text_en]"]').value = data.text_en;
        }
    }

    renumber();
    index++;
}

function removeRow(btn) {
    btn.closest('tr').remove();
    renumber();
}

function renumber() {
    document.querySelectorAll('#contenu-body tr').forEach((row, i) => {
        row.querySelector('.row-number').innerText = i + 1;
    });
}

function changeNature(select) {
    let td = select.closest('tr').querySelector('.contenu-column');
    let namePrefix = select.name.replace('[nature]', '');
    td.innerHTML = "";

    if (select.value === 'image') {
        td.innerHTML = `<input type="file" name="${namePrefix}[image]" class="form-control">`;
    }
    if (select.value === 'video') {
        td.innerHTML = `<input type="text" name="${namePrefix}[url_video]" class="form-control" placeholder="رابط الفيديو (YouTube)">`;
    }
    if (select.value === 'texte') {
        td.innerHTML = `
            <textarea name="${namePrefix}[text_ar]" rows="3" class="form-control mb-2 tinymce"></textarea>
            <textarea name="${namePrefix}[text_fr]" rows="3" class="form-control mb-2 tinymce"></textarea>
            <textarea name="${namePrefix}[text_en]" rows="3" class="form-control tinymce"></textarea>
        `;
        setTimeout(initTiny, 100);
    }
}

function initTiny() {
    tinymce.init({
        selector: '.tinymce',
        height: 180,
        plugins: 'advlist autolink lists link image preview code',
        toolbar: 'undo redo | bold italic | bullist numlist | alignleft aligncenter alignright | code'
    });
}

// Charger les contenus existants
document.addEventListener('DOMContentLoaded', () => {
    @foreach($builder->contenus as $contenu)
        @php
            $contenuData = $contenu->toArray();
            if($contenu->nature === 'image' && $contenu->image) {
                $contenuData['image'] = base64_encode($contenu->image);
            }
        @endphp
        addRow(@json($contenuData));
    @endforeach
});
</script>

<!-- STYLES TABLEAU -->
<style>
.custom-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
    border-radius: 8px;
    overflow: hidden;
    background-color: #fff;
    box-shadow: 0 1px 4px rgba(0,0,0,0.1);
}
.custom-table th, .custom-table td {
    vertical-align: middle;
    text-align: center;
    padding: 10px 6px;
    border-bottom: 1px solid #e9ecef;
}
.btn-sm { 
    padding: 6px 12px; 
    font-size: 14px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 36px;
    min-height: 36px;
}
.btn-sm i { font-size: 16px; line-height: 1; }
.me-1 { margin-right: 8px !important; }
.custom-table td.text-center { white-space: nowrap; }
.block-card-footer .btn { display: inline-flex; align-items: center; gap: 8px; padding: 10px 20px; }
.block-card-footer .btn i { font-size: 18px; }
</style>
@endsection
