@extends('backoffice.authentification.layouts_auth.app_auth')
@section('content')
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <section class="login-area section--padding text-rtl" style="margin-top: 100px;">
    <div class="container">
@if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif


    <div class="row">
        <div class="col-lg-6 mx-auto">
            <div class="card shadow-card">
                <div class="card-body">
                    <h4 class="card-title text-center" style="color:#A2052B;font-size: 25px"><strong>تعيين كلمة المرور</strong></h4>
                    <form id="set-password-form" action="{{ route('admin.password.update', $utilisateur->id) }}" method="POST">
                        @csrf
                        
                        <input type="hidden" name="token" value="{{ request('token') }}">
                        <input type="hidden" name="email" value="{{ request('email') }}">

                        <div class="form-group">
                            <label for="mdp" style="color:#A2052B">كلمة المرور الجديدة</label>
                            <input 
                                type="password" 
                                name="mdp" 
                                id="password" 
                                class="form-control"
                                placeholder="أدخل كلمة المرور الجديدة" 
                                required 
                                oninput="validatePassword()"
                            >
                         
                            @error('password')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="password_confirmation" style="color:#A2052B">تأكيد كلمة المرور</label>
                            <input 
                                type="password" 
                                name="mdp_confirmation" 
                                id="password_confirmation"
                                class="form-control" 
                                placeholder="أعد كتابة كلمة المرور" 
                                required
                            >
                            @error('password_confirmation')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <ul id="password-requirements" style="color: #A2052B; font-size: 14px; margin-top: 5px;">
                                <li id="min-length" style="color: red;">يجب أن تحتوي على 8 أحرف على الأقل</li>
                                <li id="uppercase" style="color: red;">يجب أن تحتوي على حرف كبير واحد على الأقل</li>
                                <li id="lowercase" style="color: red;">يجب أن تحتوي على حرف صغير واحد على الأقل</li>
                                <li id="special-char" style="color: red;">يجب أن تحتوي على رمز خاص واحد على الأقل</li>
                            </ul>
                            <br>
                            <div class="form-group mt-3">
                              <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                              <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                            </div>

                                    
                        <div class="flex items-center justify-end mt-4">
                                    
                                    <button type="submit" class="btn btn-block red-button">
                                        {{ __('تعيين كلمة المرور') }}
                                    </button>
                        </div>                        
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

    </section>

@endsection
