@extends('backoffice.dashboard')

@section('content')

<style>
.card-resume { border-radius: 10px; box-shadow: 0 6px 18px rgba(0,0,0,0.06); }
.small-muted { font-size: .85rem; color:#6c757d; }
.form-label { font-weight: 600; }

/* cards restauration */
.resto-card {
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.04);
    padding: 10px;
    margin-bottom: 10px;
    direction: rtl;
    background: #fff;
}
.resto-card .resto-header { display:flex; justify-content:space-between; align-items:center; gap:10px; }
.resto-card .resto-name { font-weight:700; }
.resto-card .resto-price { font-weight:700; }
.resto-card .resto-desc { color:#555; margin-top:6px; white-space:pre-wrap; }
.empty-placeholder { color:#6c757d; font-size:.95rem; padding:8px; }

.status-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 8px;
    font-weight: 600;
    min-width: 75px;
    text-align: center;
    transition: 0.3s;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

.status-badge--success {
    background-color: #e8f9ee;
    color: #27ae60;
}
.status-badge--danger {
    background-color: #fde8ea;
    color: #e74c3c;
}
.status-badge--pending {
    background-color: #fff8e1;
    color: #d4a017;
}
</style>

<div class="container mt-4" dir="rtl">
    <div class="card p-4 shadow-sm">

        <h3 class="mb-4 text-center" style="color:#d82b2a;">تفاصيل الحجز</h3>

        <div class="row">

            <div class="col-lg-8">
                <div class="card p-3 mb-3">
                    <div class="row">

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"   class="form-label">الإسم و اللقب</label>
                            <input type="text" class="form-control bg-white" value="{{ $reservation->utilisateur->nom_prenom ?? '-' }}" readonly>

                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">البريد الإلكتروني</label>
                            <input style="text-transform: none; direction: rtl;"  type="email" class="form-control bg-white"
                                value="{{ $reservation->utilisateur->email ?? '-' }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">رقم الهاتف</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->utilisateur->tel ?? '-' }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">العنوان</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->utilisateur->adresse ?? '-' }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ الوصول</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->date_arrive }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ المغادرة</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->date_depart }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الرجال</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $reservation->nbr_h }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد النساء</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $reservation->nbr_f }}" readonly>
                        </div>

                        @php
                            $nights = \Carbon\Carbon::parse($reservation->date_arrive)
                                ->diffInDays(\Carbon\Carbon::parse($reservation->date_depart));
                            $basePrice = ($reservation->auberge->prix_lit ?? 0)
                                * ($reservation->nbr_personnes ?? 0)
                                * $nights;
                            $restoTotal = $reservation->restaurations->sum(fn($r) => $r->pivot->tarif ?? 0);
                            $calculatedTotal = $basePrice + $restoTotal;
                            $selectedIds = $reservation->restaurations->pluck('id_rest')->toArray();
                        @endphp

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الليالي</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $nights }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد النزلاء</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $reservation->nbr_personnes }}" readonly>
                        </div>

                        <div class="col-12 mb-3">
    <label class="form-label">خدمات الطعام (محفوظة)</label>

    @if($reservation->restaurations->isEmpty())
        <div class="empty-placeholder">لا توجد خدمات إضافية محفوظة</div>
    @else
        @foreach($reservation->restaurations as $resto)
            <div class="resto-card">
                <div class="resto-header">
                    <div class="resto-name">{{ $resto->nom_ar }}</div>
                    <div class="resto-price">{{ number_format($resto->pivot->tarif, 2) }} د</div>
                </div>
                <div class="resto-desc">{!! nl2br(e($resto->description_ar ?? '—')) !!}</div>
            </div>
        @endforeach
    @endif
</div>


                        <div class="col-12 mb-3">
                            <label style="color:black;"  class="form-label">الملاحظات</label>
                            <div class="mt-2 p-2 border border-gray rounded bg-white">
                            <p rows="3" readonly class="form-label bg-white">{{ $reservation->remarque ?? '—' }}</p>
                        </div>
                        </div>

                         
                    </div>
                </div>
            </div>

            <div class="col-lg-4">

    <div class="card p-3 card-resume mb-3">
        <h5 class="mb-2" style="color:#d82b2a;">ملخص الحجز</h5>

        <p class="small-muted mb-1">
            المؤسسة: <strong>{{ $reservation->auberge->nom ?? '-' }}</strong>
        </p>

        <p class="small-muted mb-1">
            سعر الليلة: <strong>{{ number_format($reservation->auberge->prix_lit ?? 0, 2) }}</strong> د
        </p>

        <p class="small-muted mb-1">عدد الليالي: <strong>{{ $nights }}</strong></p>

        
        <div class="mt-2 p-2 border border-gray rounded bg-white">
            <strong class="text-black"> الملاحظات:</strong>
            <p class="mb-0">{{ $reservation->remarque ?? '—' }}</p>
        </div>
        <hr>
        <p class="small-muted mb-1">
            السعر الأساسي: <strong>{{ number_format($basePrice, 2) }} د</strong>
        </p>

        <p class="small-muted mb-1">
            خدمات الطعام: <strong>{{ number_format($restoTotal, 2) }} د</strong>
        </p>

        <p class="mb-3">
            المجموع الكلي: <strong>{{ number_format($calculatedTotal, 2) }} د</strong>
        </p>

       <div class="card p-3 card-resume mb-3">
        <h5 class="mb-2" style="color:#d82b2a;">الغرف و التعيينات</h5>

       @forelse ($affectations as $aff)
            <div class="p-2 mb-2 border rounded bg-white">
                <strong>الغرفة رقم: </strong> {{ $aff->chambreTente->nom ?? $aff->chambre_tente_id }} <br>
                <strong>رجال: </strong> {{ $aff->male_personnes }} <br>
                <strong>نساء: </strong> {{ $aff->female_personnes }} <br>
                <strong>المجموع: </strong> {{ $aff->total_personnes }}
            </div>
        @empty
            <p class="text-muted text-center">لا توجد تعيينات محفوظة</p>
        @endforelse

    </div>
        <a href="{{ route('reservation.index') }}"
            class="btn btn-secondary mt-3 w-100" style="background-color:#1a237e;">
            رجوع إلى قائمة الحجوزات
        </a>
    </div>
</div>
        </div>
    </div>
</div>
@endsection