@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if(Auth::check())

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form action="{{ route('auberges.update', $auberge->id) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')  {{-- Important pour update --}}
        
        <h3 class="mb-4 text-center"> تعديل معلومات مركب أو مركز إقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم بالعربية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_ar" type="text" class="form-control @error('nom_ar') is-invalid @enderror"  
					   value="{{ old('nom_ar', $auberge->nom_ar) }}">
				@error('nom_ar')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الإسم بالفرنسية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_fr" type="text" class="form-control @error('nom_fr') is-invalid @enderror"  
					   value="{{ old('nom_fr', $auberge->nom_fr) }}">
				@error('nom_fr')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم بالإنقليزية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_en" type="text" class="form-control @error('nom_en') is-invalid @enderror"  
					   value="{{ old('nom_en', $auberge->nom_en) }}">
				@error('nom_en')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الصبغة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="epa" class="form-control @error('epa') is-invalid @enderror">
					<option value="">-- اختر الصبغة --</option>
					<option value="EPA" {{ old('epa', $auberge->epa) == 'EPA' ? 'selected' : '' }}>EPA</option>
					<option value="Non EPA" {{ old('epa', $auberge->epa) == 'Non EPA' ? 'selected' : '' }}>Non EPA</option>
				</select>
				@error('epa')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>


        <div class="form-group mt-3">
			<label for="description_ar" class="col-sm-6 col-form-label">تعريف المركز بالعربية<span class="text-danger">*</span></label>
			<textarea name="description_ar" id="description_ar" class="form-control @error('description_ar') is-invalid @enderror" rows="4">{{ old('description_ar', $auberge->description_ar ?? '') }}</textarea>
			@error('description_ar')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="form-group mt-3">
			<label for="description_fr" class="col-sm-6 col-form-label">تعريف المركز بالفرنسية<span class="text-danger">*</span></label>
			<textarea name="description_fr" id="description_fr" class="form-control @error('description_fr') is-invalid @enderror" rows="4">{{ old('description_fr', $auberge->description_fr ?? '') }}</textarea>
			@error('description_fr')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="form-group mt-3">
			<label for="description_en" class="col-sm-6 col-form-label">تعريف المركز بالإنقليزية<span class="text-danger">*</span></label>
			<textarea name="description_en" id="description_en" class="form-control @error('description_en') is-invalid @enderror" rows="4">{{ old('description_en', $auberge->description_en ?? '') }}</textarea>
			@error('description_en')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">خط العرض (Latitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="latitude" class="form-control @error('latitude') is-invalid @enderror"
					   value="{{ old('latitude', $auberge->latitude ?? '') }}"
					   placeholder="مثلاً: 36.8065">
				@error('latitude')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">خط الطول (Longitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="longitude" class="form-control @error('longitude') is-invalid @enderror"
					   value="{{ old('longitude', $auberge->longitude ?? '') }}"
					   placeholder="مثلاً: 10.1815">
				@error('longitude')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3">
			<div class="col-12">
				<h5 class="text-end">تحديد موقع المركز على الخريطة</h5>
			</div>
		</div>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">X (خط العرض) تلقائي</label>
			<div class="col-sm-4">
				<input type="text" name="x" 
					   class="form-control" 
					   value="{{ old('x', $auberge->x) }}">
				@error('x')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
			<label class="col-sm-2 col-form-label">Y (خط الطول) تلقائي</label>
			<div class="col-sm-4">
				<input type="text" name="y" 
					   class="form-control" 
					   value="{{ old('y', $auberge->y) }}">
				@error('y')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">رابط Google Map</label>
			<div class="col-sm-10">
				<input type="text" name="map_link" 
					   class="form-control" 
					   value="{{ old('map_link', $auberge->map_link ?: 'https://maps.google.com/?q='.$auberge->x.','.$auberge->y) }}">
			</div>
		</div>


        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الوسط الذي توجد به المؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="id_milieu_auberge" class="form-control @error('id_milieu_auberge') is-invalid @enderror">
					<option value="">-- اختر الوسط --</option>
					@foreach($milieux as $milieu)
						<option value="{{ $milieu->id_type }}" {{ old('id_milieu_auberge', $auberge->id_milieu_auberge) == $milieu->id_type ? 'selected' : '' }}>
							{{ $milieu->type_ar }}
						</option>
					@endforeach
				</select>
				@error('id_milieu_auberge')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">العنوان <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="adresse" class="form-control @error('adresse') is-invalid @enderror" 
					   value="{{ old('adresse', $auberge->adresse) }}">
				@error('adresse')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">الترقيم البريدي <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="code_postal" class="form-control @error('code_postal') is-invalid @enderror"
					   value="{{ old('code_postal', $auberge->code_postal) }}">
				@error('code_postal')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الولاية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select class="form-control @error('gouvernorat_id') is-invalid @enderror" id="gouvernorat_id" name="gouvernorat_id">
					<option value="" disabled>اختر...</option>
					@foreach($gouvernorats as $gouv)
						<option value="{{ $gouv->id_gouver }}" {{ old('gouvernorat_id', $auberge->gouver_id) == $gouv->id_gouver ? 'selected' : '' }}>
							{{ $gouv->nom_ar }}
						</option>
					@endforeach
				</select>
				@error('gouvernorat_id')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">المعتمدية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select class="form-control @error('delegation_id') is-invalid @enderror" id="delegation_id" name="delegation_id" {{ $auberge->delegation_id ? '' : 'disabled' }}>
					<option value="" disabled {{ old('delegation_id', $auberge->delegation_id ?? '') ? '' : 'selected' }}>اختر...</option>
					@if($auberge->delegation_id)
						@foreach($delegations as $del)
							<option value="{{ $del->id_delegation }}"
								{{ old('delegation_id', $auberge->delegation_id ?? '') == $del->id_delegation ? 'selected' : '' }}>
								{{ $del->nom_ar }}
							</option>
						@endforeach
					@endif
				</select>
				@error('delegation_id')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الهاتف القار <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="contact_tel" class="form-control @error('contact_tel') is-invalid @enderror" 
					   value="{{ old('contact_tel', $auberge->contact_tel) }}">
				@error('contact_tel')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">الفاكس <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="fax" class="form-control @error('fax') is-invalid @enderror" 
					   value="{{ old('fax', $auberge->fax) }}">
				@error('fax')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end align-items-start">
			<label class="col-sm-2 col-form-label">البريد الإلكتروني للمؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="email" name="contact_email" class="form-control @error('contact_email') is-invalid @enderror" 
					   value="{{ old('contact_email', $auberge->contact_email ?? '') }}">
				@error('contact_email')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label for="image" class="col-sm-2 col-form-label">صورة المركب <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="file" name="image" id="image" class="form-control @error('image') is-invalid @enderror" accept="image/*">
				@error('image')
					<span class="text-danger small">{{ $message }}</span>
				@enderror

				@if(!empty($auberge->image))
					<div class="mt-2 text-center">
						<img src="data:image/jpeg;base64,{{ base64_encode($auberge->image) }}"
							 alt="الصورة الحالية"
							 style="max-width: 200px; max-height: 150px; border-radius: 8px; object-fit: cover; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
					</div>
				@endif
			</div>
		</div>

        <!--div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">سعر الليلة (سرير) <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input hidden type="number" name="prix_lit" class="form-control" 
					value="{{ old('prix_lit', $auberge->prix_lit ?? '') }}" step="0.01" min="0">
				@error('prix_lit')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div-->
<input hidden type="number" name="prix_lit" class="form-control" value="{{ old('prix_lit', $auberge->prix_lit ?? '') }}" step="0.01" min="0">
		<h4 class="mt-3"> مدير المؤسسة </h4>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">  الإسم واللقب <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="nom_directeur" class="form-control"
					value="{{ old('nom_directeur', $auberge->nom_directeur) }}">
				@error('nom_directeur')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الهاتف الجوال <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="tel_directeur" class="form-control"
					value="{{ old('tel_directeur', $auberge->tel_directeur) }}">
				@error('tel_directeur')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<h4 class="mt-3"> الخدمات</h4>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> هل يوجد فضاء للمشروبات ؟ <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="espace_boisson" id="espace_boisson" class="form-control" >
					<option value="" disabled {{ old('espace_boisson', $auberge->espace_boisson) === null ? 'selected' : '' }}>اختر...</option>
					<option value="1" {{ old('espace_boisson', $auberge->espace_boisson) == 1 ? 'selected' : '' }}>نعم</option>
					<option value="0" {{ old('espace_boisson', $auberge->espace_boisson) == 0 ? 'selected' : '' }}>لا</option>
				</select>
				@error('espace_boisson')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
			
			<label class="col-sm-2 col-form-label"> مسبح  <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="piscine" class="form-control" >
					<option value="" disabled {{ old('piscine', $auberge->piscine) === null ? 'selected' : '' }}>اختر...</option>
					<option value="1" {{ old('piscine', $auberge->piscine) == 1 ? 'selected' : '' }}>نعم</option>
					<option value="0" {{ old('piscine', $auberge->piscine) == 0 ? 'selected' : '' }}>لا</option>
				</select>
				@error('piscine')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>













<div class="form-group row mt-4">

    <h5 class="text-center mb-3">تعريفات الإقامة</h5>

    <table id="tarifs-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>فرادى / مجموعات</th>
                <th>نوع الوفد المقيم</th>
                <th>بالمباني</th>
                <th>تحت الخيام</th>
                <th>ملاحظات</th>
                <th>إجراء</th>
            </tr>
        </thead>

        <tbody id="tarifs-body">
            <!-- LIGNES STATIQUES ORIGINALES REQUIRED -->
            
            <tr>
                <td class="row-number">1</td>

                <td>
                    <select name="tarifs[0][categorie]" class="form-control">
                        <option>أفراد</option>
                        <option selected>مجموعات</option>
                    </select>
                </td>

                <td>
                    <select name="tarifs[0][type]" class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option selected>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[0][hotel]" class="form-control" value="4000"></td>
                <td><input type="number" name="tarifs[0][tentes]" class="form-control" value="1500"></td>

                <td><input type="text" name="tarifs[0][note]" class="form-control"
                         value="وجوب تقديم قائمة اسمية للمجموعة مؤشرة من قبل مدير المؤسسة المستفيدة"></td>

                <td><button type="button" class="btn btn-danger btn-sm" onclick="removeTarifRow(this)">حذف</button></td>
            </tr>

            <!-- Ligne 2 -->
            <tr>
                <td class="row-number">2</td>

                <td>
                    <select name="tarifs[1][categorie]" class="form-control">
                        <option>أفراد</option>
                        <option selected>مجموعات</option>
                    </select>
                </td>

                <td>
                    <select name="tarifs[1][type]" class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option selected>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="6000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="2500"></td>

                <td><input type="text" name="tarifs[1][note]" class="form-control"
                         value="وجوب تقديم قائمة اسمية للمجموعة مؤشرة من قبل الهيكل أو الجمعية"></td>

                <td><button type="button" class="btn btn-danger btn-sm" onclick="removeTarifRow(this)">حذف</button></td>
            </tr>

<!-- Ligne 3 -->
            <tr>
			<td class="row-number">3</td>
                <td>
                    <select class="form-control">
                        <option>المجموعات</option>
                        <option selected>مجموعات</option>
                        <option>أفراد</option>
                    </select>
                </td>

                <td>
                    <select class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option selected>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="15000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="7000"></td>

                <td><input type="text" class="form-control" placeholder=""></td>

                <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this)">حذف</button></td>
            </tr>

            <!-- Ligne 4 -->
            <tr>
			<td class="row-number">4</td>
                <td>
                    <select class="form-control">
                        <option>المجموعات</option>
                        <option selected>مجموعات</option>
                        <option>أفراد</option>
                    </select>
                </td>

                <td>
                    <select class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option selected>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="7000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="3500"></td>

                <td><input type="text" class="form-control" placeholder=""></td>

                <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this)">حذف</button></td>
            </tr>

            <!-- Ligne 5 -->
            <tr>
			<td class="row-number">5</td>
                <td>
                    <select class="form-control">
                        <option>المجموعات</option>
                        <option selected>مجموعات</option>
                        <option>أفراد</option>
                    </select>
                </td>

                <td>
                    <select class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option selected>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="12000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="6000"></td>

                <td><input type="text" class="form-control" placeholder=""></td>

                <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this)">حذف</button></td>
            </tr>        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addTarifRow()">إضافة تعريف جديد</button>
</div>

<div class="form-group row mt-4">

    <h5 class="text-center mb-3">وقف عربات التخييم داخل المركز (في اليوم الواحد) </h5>
    <div class="mb-4">
        <div class="d-inline-block ms-2" style="width:150px;">
            <input type="number" class="form-control" id="camping-fee" value="7000">
        </div>
        <div class="small-note mt-2">يمكن تعديل القيمة.</div>
    </div>

</div>

<script>
function updateTarifRowNumbers() {
    document.querySelectorAll("#tarifs-body .row-number").forEach((cell, index) => {
        cell.textContent = index + 1;
    });
}

function removeTarifRow(button) {
    button.closest("tr").remove();
    updateTarifRowNumbers();
}

function addTarifRow() {
    let tableBody = document.getElementById("tarifs-body");
    let index = tableBody.children.length;

    let row = `
        <tr>
            <td class="row-number">${index + 1}</td>

            <td>
                <select name="tarifs[${index}][categorie]" class="form-control">
                    <option>أفراد</option>
                    <option selected>مجموعات</option>
                </select>
            </td>

            <td>
                <select name="tarifs[${index}][type]" class="form-control">
				 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                    <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                    <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                    <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                    <option>المجموعات الأجنبية (إطار التبادل)</option>
                    <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                </select>
            </td>

            <td><input type="number" name="tarifs[${index}][hotel]" class="form-control"></td>
            <td><input type="number" name="tarifs[${index}][tentes]" class="form-control"></td>

            <td><input type="text" name="tarifs[${index}][note]" class="form-control"></td>

            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeTarifRow(this)">حذف</button></td>
        </tr>
    `;

    tableBody.insertAdjacentHTML('beforeend', row);
    updateTarifRowNumbers();
}
</script>


















        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الفضاءات المتوفرة</h5>

			<table id="espaces-table" class="table table-bordered">
				<thead>
					<tr>
						<th></th>
						<th>الإسم بالعربية</th>
						<th>الإسم بالفرنسية</th>
						<th>الإسم بالانقليزية</th>
						<th>إجراء</th>
					</tr>
				</thead>
				<tbody id="espaces-body">
					@php
						// On prend soit les anciennes valeurs après validation, soit les espaces existants
						$oldEspaces = old('espaces', $auberge->espaces->toArray());
						$espaceIndex = 0;
					@endphp

					@foreach($oldEspaces as $espace)
					<tr>
						<td class="row-number">{{ $loop->iteration }}</td>
						<td>
							<input type="hidden" name="espaces[{{ $espaceIndex }}][id_espace]" value="{{ $espace['id_espace'] ?? '' }}">
							<input type="text" name="espaces[{{ $espaceIndex }}][nom_ar]" class="form-control" value="{{ $espace['nom_ar'] ?? '' }}" >
						</td>
						<td>
							<input type="text" name="espaces[{{ $espaceIndex }}][nom_fr]" class="form-control" value="{{ $espace['nom_fr'] ?? '' }}" >
						</td>
						<td>
							<input type="text" name="espaces[{{ $espaceIndex }}][nom_en]" class="form-control" value="{{ $espace['nom_en'] ?? '' }}" >
						</td>
						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
						</td>
					</tr>
					@php $espaceIndex++; @endphp
					@endforeach
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addEspaceRow()">إضافة فضاء جديد</button>
		</div>


        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الغرف <span class="text-danger">*</span></h5>
			<table id="chambres-table" class="custom-table">
				<thead>
					<tr>
						<th></th>
						<th>نوع الغرفة</th>
						<th>الطاقة الاستيعابية</th>
						<th>رقم الغرفة</th>
						<th>إجراء</th>
					</tr>
				</thead>

				<tbody id="chambres-body">
					@php
						$oldChambres = old('chambres', isset($auberge) ? $auberge->chambres->toArray() : []);
					@endphp

					@foreach($oldChambres as $index => $c)
					<tr>
						<td class="row-number">{{ $index + 1 }}</td>

						{{-- Type de chambre --}}
						<td>
							<select name="chambres[{{ $index }}][type_chambre_id]" class="form-control type-chambre" >
								<option value="">-- اختر --</option>
								@foreach($typesChambres as $t)
									<option value="{{ $t->id_type }}" 
										{{ ($c['type_chambre_id'] ?? '') == $t->id_type ? 'selected' : '' }}>
										{{ $t->type_ar }}
									</option>
								@endforeach
							</select>
							<input type="hidden" name="chambres[{{ $index }}][id_chambre_tente]" value="{{ $c['id_chambre_tente'] ?? '' }}">
							@error("chambres.$index.type_chambre_id")
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						{{-- Capacité --}}
						<td>
							<input type="number" name="chambres[{{ $index }}][capacite]" class="form-control nb-lits" value="{{ $c['capacite'] ?? '' }}">
							@error("chambres.$index.capacite")
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						{{-- Numéro de chambre --}}
						<td>
							<input type="text" name="chambres[{{ $index }}][num_chambre]" class="form-control" value="{{ $c['num_chambre'] ?? '' }}">
							@error("chambres.$index.num_chambre")
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button>
						</td>
					</tr>
					@endforeach
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addChambreRow()">إضافة غرفة</button>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="number" name="capacite_batiment" id="capacite_batiment" class="form-control" 
					value="{{ old('capacite_batiment', $auberge->capacite_batiment ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres" id="nb_chambres" class="form-control" 
					value="{{ old('nb_chambres', $auberge->nb_chambres ?? 0) }}" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف الفردية</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_single" id="nb_chambres_single" class="form-control" 
					value="{{ old('nb_chambres_single', $auberge->nb_chambres_single ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف ثنائي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_double" id="nb_chambres_double" class="form-control" 
					value="{{ old('nb_chambres_double', $auberge->nb_chambres_double ?? 0) }}" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف ثلاثي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_triple" id="nb_chambres_triple" class="form-control" 
					value="{{ old('nb_chambres_triple', $auberge->nb_chambres_triple ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف رباعي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_quadra" id="nb_chambres_quadra" class="form-control" 
					value="{{ old('nb_chambres_quadra', $auberge->nb_chambres_quadra ?? 0) }}" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف أكثر من رباعي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_plus" id="nb_chambres_plus" class="form-control" 
					value="{{ old('nb_chambres_plus', $auberge->nb_chambres_plus ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الوحدات الصحية داخل الغرف</label>
			<div class="col-sm-4">
				<input type="number" name="nb_salles_de_bain" id="nb_salles_de_bain" class="form-control" 
					value="{{ old('nb_salles_de_bain', $auberge->nb_salles_de_bain ?? 0) }}">
			</div>
		</div>




        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain_comm" class="form-control" 
                    value="{{ old('nb_salles_de_bain_comm', $auberge->nb_salles_de_bain_comm) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_tv" class="form-control" 
                    value="{{ old('nb_chambres_tv', $auberge->nb_chambres_tv) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف المكيفة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_clim" class="form-control" 
                    value="{{ old('nb_chambres_clim', $auberge->nb_chambres_clim) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_frigo" class="form-control" 
                    value="{{ old('nb_chambres_frigo', $auberge->nb_chambres_frigo) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4">
                <input type="number" name="capacite_tentes" class="form-control" 
                    value="{{ old('capacite_tentes', $auberge->capacite_tentes) }}">
            </div>
            <label for="cuisine_fonctionnelle" class="col-sm-2 col-form-label">المطبخ وظيفي</label>
            <div class="col-sm-4">
                <select name="cuisine_fonctionnelle" id="cuisine_fonctionnelle" class="form-control">
                    <option value="" disabled>اختر...</option>
                    <option value="1" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '1' ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '0' ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>


       

                <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الملاعب الرياضية</h5>

    <table id="terrains-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="terrains-body">
            @php
                $oldterrains = old('terrains', $auberge->terrains->toArray());
                $terrainsIndex = 0;
            @endphp

            @foreach($oldterrains as $terrain)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <input type="hidden" name="terrains[{{ $terrainsIndex }}][id_terrain]" value="{{ $terrain['id_terrain'] ?? '' }}">
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_ar]" class="form-control" value="{{ $terrain['nom_ar'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_fr]" class="form-control" value="{{ $terrain['nom_fr'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_en]" class="form-control" value="{{ $terrain['nom_en'] ?? '' }}" >
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeterrainsRow(this)">حذف</button>
                </td>
            </tr>
            @php $terrainsIndex++; @endphp
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addterrainsRow()">إضافة فضاء جديد</button>
</div>

<script>
let terrainsIndex = {{ $terrainsIndex ?? 0 }};

function addterrainsRow() {
    let tableBody = document.getElementById('terrains-body');

    let newRow = `
        <tr>
            <td class="row-number">${terrainsIndex + 1}</td>
            <td>
                <input type="hidden" name="terrains[${terrainsIndex}][id_terrain]" value="">
                <input type="text" name="terrains[${terrainsIndex}][nom_ar]" class="form-control" >
            </td>
            <td>
                <input type="text" name="terrains[${terrainsIndex}][nom_fr]" class="form-control" >
            </td>
            <td>
                <input type="text" name="terrains[${terrainsIndex}][nom_en]" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeterrainsRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    terrainsIndex++;
    updateterrainsRowNumbers();
}

function removeterrainsRow(button) {
    button.closest('tr').remove();
    updateterrainsRowNumbers();
}

function updateterrainsRowNumbers() {
    document.querySelectorAll('#terrains-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>

        


        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الخدمات المقدمة من طرف المؤسسة</h5>

    <table id="services_auberge-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="services_auberge-body">
            @php
                $oldservices_auberge = old('services_auberge', $auberge->services_auberge->toArray());
                $services_aubergeIndex = 0;
            @endphp

            @foreach($oldservices_auberge as $services_auberge)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <input type="hidden" name="services_auberge[{{ $services_aubergeIndex }}][id_service]" value="{{ $services_auberge['id_service'] ?? '' }}">
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_ar]" class="form-control" value="{{ $services_auberge['nom_ar'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_fr]" class="form-control" value="{{ $services_auberge['nom_fr'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_en]" class="form-control" value="{{ $services_auberge['nom_en'] ?? '' }}" >
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
                </td>
            </tr>
            @php $services_aubergeIndex++; @endphp
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addservices_aubergeRow()">إضافة فضاء جديد</button>
</div>

<script>
let services_aubergeIndex = {{ $services_aubergeIndex ?? 0 }};

function addservices_aubergeRow() {
    let tableBody = document.getElementById('services_auberge-body');

    let newRow = `
        <tr>
            <td class="row-number">${services_aubergeIndex + 1}</td>
            <td>
                <input type="hidden" name="services_auberge[${services_aubergeIndex}][id_service]" value="">
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_ar]" class="form-control" >
            </td>
            <td>
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_fr]" class="form-control" >
            </td>
            <td>
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_en]" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    services_aubergeIndex++;
    updateservices_aubergeRowNumbers();
}

function removeservices_aubergeRow(button) {
    button.closest('tr').remove();
    updateservices_aubergeRowNumbers();
}

function updateservices_aubergeRowNumbers() {
    document.querySelectorAll('#services_auberge-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>


    <div class="form-group row mt-4">
        <h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>
        <table id="restauration-table" class="custom-table">
            <thead>
                <tr>
                    <th></th>
                    <th>الإسم بالعربية</th>
                    <th>الإسم بالفرنسية</th>
                    <th>الإسم بالإنجليزية</th>
                    <th>الوصف بالعربية</th>
                    <th>الوصف بالفرنسية</th>
                    <th>الوصف بالإنجليزية</th>
                    <th>التعريفة (د.ت)</th>
                    <th>إجراء</th> 
                </tr>
            </thead>
            <tbody id="restauration-body">
                @foreach($auberge->restaurations as $i => $res)
                    <tr>
                        <td class="row-number"></td>
                        <td>
                            <input type="hidden" name="restaurations[{{ $i }}][id_rest]" value="{{ $res->id_rest }}">
                            <input type="text" name="restaurations[{{ $i }}][nom_ar]" value="{{ $res->nom_ar }}" class="form-control"></td>
                        <td><input type="text" name="restaurations[{{ $i }}][nom_fr]" value="{{ $res->nom_fr }}" class="form-control"></td>
                        <td><input type="text" name="restaurations[{{ $i }}][nom_en]" value="{{ $res->nom_en }}" class="form-control"></td>
                        <td><textarea name="restaurations[{{ $i }}][description_ar]" class="form-control">{{ $res->description_ar }}</textarea></td>
                        <td><textarea name="restaurations[{{ $i }}][description_fr]" class="form-control">{{ $res->description_fr }}</textarea></td>
                        <td><textarea name="restaurations[{{ $i }}][description_en]" class="form-control">{{ $res->description_en }}</textarea></td>
                        <td><input type="number" step="0.01" name="restaurations[{{ $i }}][tarif]" value="{{ $res->tarif }}" class="form-control"></td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>
        <button type="button" class="btn btn-success mt-2" onclick="addRestaurationRow()">إضافة خدمة جديدة</button>
    </div>

        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة</label>
            <textarea name="lieux_culturels" id="lieux_culturels" class="form-control" rows="4">{{ old('lieux_culturels', $auberge->lieux_culturels) }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label"> خدمات أخرى </label>
            <textarea name="autres_services" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services', $auberge->autres_services) }}</textarea>
        </div>

        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success mx-2">
                <i class="la la-save"></i> حفظ التعديلات
            </button>

            <a href="{{ route('auberges.index') }}" class="btn btn-secondary mx-2">
                <i class="la la-arrow-right"></i> رجوع
            </a>
        </div>

    </form>
</div>

<script>
    let restaurationIndex = {{ count($auberge->restaurations) }};
    function addRestaurationRow() {
        let tableBody = document.getElementById('restauration-body');
        let newRow = `
            <tr>
                <td class="row-number"></td>

                <td><input type="text" name="restaurations[${restaurationIndex}][nom_ar]" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_fr]" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_en]" class="form-control" ></td>

                <td><textarea name="restaurations[${restaurationIndex}][description_ar]" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_fr]" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_en]" class="form-control" rows="1"></textarea></td>

                <td><input type="number" step="0.01" name="restaurations[${restaurationIndex}][tarif]" class="form-control" ></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                </td>
            </tr>
        `;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        restaurationIndex++;
        updateRowNumbers();
    }
    function removeRestaurationRow(button) {
        button.closest('tr').remove();
        updateRowNumbers();
    }
    function updateRowNumbers() {
        document.querySelectorAll('#restauration-body .row-number')
            .forEach((cell, index) => cell.textContent = index + 1);
    }
    updateRowNumbers();
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {

    const gouvSelect = document.getElementById('gouvernorat_id');
    const delSelect  = document.getElementById('delegation_id');

    gouvSelect.addEventListener('change', function () {

        let gouvId = this.value;

        delSelect.innerHTML = '';
        delSelect.disabled = true;

        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';

        let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";
        url = url.replace("ID_PLACEHOLDER", gouvId);

        fetch(url)
            .then(response => response.json())
            .then(data => {

                
                delSelect.innerHTML = '<option disabled selected>اختر...</option>';

                
                data.forEach(d => {
                    let option = document.createElement('option');
                    option.value = d.id_delegation;
                    option.text  = d.nom_ar;
                    delSelect.appendChild(option);
                });

                delSelect.disabled = false;
            });
    });

});
</script>
<script>
let espaceIndex = {{ $espaceIndex ?? 0 }};

function addEspaceRow() {
    let tableBody = document.getElementById('espaces-body');

    let newRow = `
        <tr>
            <td class="row-number">${espaceIndex + 1}</td>
            <td>
                <input type="hidden" name="espaces[${espaceIndex}][id_espace]" value="">
                <input type="text" name="espaces[${espaceIndex}][nom_ar]" class="form-control" >
            </td>
            <td>
                <input type="text" name="espaces[${espaceIndex}][nom_fr]" class="form-control" >
            </td>
            <td>
                <input type="text" name="espaces[${espaceIndex}][nom_en]" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    espaceIndex++;
    updateEspaceRowNumbers();
}

function removeEspaceRow(button) {
    button.closest('tr').remove();
    updateEspaceRowNumbers();
}

function updateEspaceRowNumbers() {
    document.querySelectorAll('#espaces-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>

<script>
function updateRowNumbers() {
    document.querySelectorAll('#chambres-body tr .row-number').forEach((td, i) => td.textContent = i + 1);
}

function recalculer() {
    const rows = document.querySelectorAll('#chambres-body tr');
    let totalChambres = 0, capaciteTotale = 0;
    let nb_single = 0, nb_double = 0, nb_triple = 0, nb_quadra = 0, nb_plus = 0;

    rows.forEach(row => {
        const typeEl = row.querySelector('.type-chambre');
        const litsEl = row.querySelector('.nb-lits');

        if (!typeEl || !litsEl) return;

        const type = typeEl.value;
        const lits = parseInt(litsEl.value || 0);

        totalChambres++;
        capaciteTotale += lits;

        switch(type){
            case "1": nb_single++; break;
            case "2": nb_double++; break;
            case "3": nb_triple++; break;
            case "4": nb_quadra++; break;
            case "6": nb_plus++; break;
        }
    });

    document.getElementById('nb_chambres').value = totalChambres;
    document.getElementById('capacite_batiment').value = capaciteTotale;
    document.getElementById('nb_chambres_single').value = nb_single;
    document.getElementById('nb_chambres_double').value = nb_double;
    document.getElementById('nb_chambres_triple').value = nb_triple;
    document.getElementById('nb_chambres_quadra').value = nb_quadra;
    document.getElementById('nb_chambres_plus').value = nb_plus;
}

function addChambreRow() {
    const tbody = document.getElementById("chambres-body");
    const index = tbody.rows.length;

    const tr = document.createElement('tr');
    tr.innerHTML = `
        <td class="row-number">${index + 1}</td>
        <td>
            <select name="chambres[${index}][type_chambre_id]" class="form-control type-chambre" >
                <option value="">-- اختر --</option>
                @foreach($typesChambres as $t)
                <option value="{{ $t->id_type }}">{{ $t->type_ar }}</option>
                @endforeach
            </select>
            <input type="hidden" name="chambres[${index}][id_chambre_tente]" value="">
        </td>
        <td><input type="number" name="chambres[${index}][capacite]" class="form-control nb-lits" ></td>
        <td><input type="text" name="chambres[${index}][num_chambre]" class="form-control" ></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button></td>
    `;
    tbody.appendChild(tr);
    updateRowNumbers();
    recalculer();
}

function removeChambreRow(btn) {
    btn.closest("tr").remove();
    updateRowNumbers();
    recalculer();
}

document.addEventListener('input', e => {
    if (e.target.classList.contains('type-chambre') || e.target.classList.contains('nb-lits')) {
        recalculer();
    }
});
document.addEventListener('change', e => {
    if (e.target.classList.contains('type-chambre')) {
        recalculer();
    }
});
document.addEventListener('DOMContentLoaded', () => {
    updateRowNumbers();
    recalculer();
});
</script>

@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
