@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if(Auth::check())
<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
		.field-error {
        color: #d9534f;
        font-size: .9rem;
        margin-top: .25rem;
        display: block; /* important */
		}
		.is-invalid { border-color: #d9534f !important; }
    </style>


    
    <form action="{{ route('auberges.store') }}" method="POST" enctype="multipart/form-data" novalidate>

        @csrf 
        <h3 class="mb-4 text-center"> استمارة اضافة مركب او مركز اقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم بالعربية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_ar" type="text" 
					   class="form-control @error('nom_ar') is-invalid @enderror"
					   value="{{ old('nom_ar') }}">
				@error('nom_ar')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الإسم بالفرنسية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_fr" type="text"  
					   class="form-control @error('nom_fr') is-invalid @enderror"  
					   value="{{ old('nom_fr') }}">
				@error('nom_fr')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>
        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">
				الإسم بالإنقليزية<span class="text-danger">*</span>
			</label>
			<div class="col-sm-4">
				<input name="nom_en" type="text"
					   class="form-control @error('nom_en') is-invalid @enderror"
					   value="{{ old('nom_en') }}">
				@error('nom_en')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الصبغة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="epa" 
						class="form-control @error('epa') is-invalid @enderror">

					<option value="">-- اختر الصبغة --</option>
					<option value="EPA" {{ old('epa') == 'EPA' ? 'selected' : '' }}>EPA</option>
					<option value="Non EPA" {{ old('epa') == 'Non EPA' ? 'selected' : '' }}>Non EPA</option>

				</select>
				@error('epa')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>


        <div class="form-group mt-3">
			<label for="description_ar" class="col-sm-6 col-form-label">تعريف المركز بالعربية<span class="text-danger">*</span></label>
			<textarea name="description_ar" id="description_ar" 
					  class="form-control @error('description_ar') is-invalid @enderror" 
					  rows="4">{{ old('description_ar') }}</textarea>
			@error('description_ar')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="form-group mt-3">
			<label for="description_fr" class="col-sm-6 col-form-label">تعريف المركز بالفرنسية<span class="text-danger">*</span></label>
			<textarea name="description_fr" id="description_fr" 
					  class="form-control @error('description_fr') is-invalid @enderror" 
					  rows="4">{{ old('description_fr') }}</textarea>
			@error('description_fr')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="form-group mt-3">
			<label for="description_en" class="col-sm-6 col-form-label">تعريف المركز بالإنقليزية<span class="text-danger">*</span></label>
			<textarea name="description_en" id="description_en" 
					  class="form-control @error('description_en') is-invalid @enderror" 
					  rows="4">{{ old('description_en') }}</textarea>
			@error('description_en')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">خط العرض (Latitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="latitude" 
					   class="form-control @error('latitude') is-invalid @enderror" 
					   value="{{ old('latitude') }}" 
					   placeholder="مثلاً: 36.8065">
				@error('latitude')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">خط الطول (Longitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="longitude" 
					   class="form-control @error('longitude') is-invalid @enderror" 
					   value="{{ old('longitude') }}" 
					   placeholder="مثلاً: 10.1815">
				@error('longitude')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>


		<div class="row mt-3">
			<div class="col-12">
				<h5 class="text-end">تحديد موقع المركز على الخريطة</h5>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">X (خط العرض) تلقائي</label>
			<div class="col-sm-4">
				<input type="text" name="x" 
					   class="form-control" 
					   value="{{ old('x') }}" 
					   >
					   @error('x')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">Y (خط الطول) تلقائي</label>
			<div class="col-sm-4">
				<input type="text" name="y" 
					   class="form-control" 
					   value="{{ old('y') }}" 
					   >
					   @error('y')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">رابط Google Map</label>
			<div class="col-sm-10">
				<input type="text" name="map_link" 
					   class="form-control" 
					   value="{{ old('x') && old('y') ? 'https://maps.google.com/?q='.old('x').','.old('y') : '' }}" 
					   >
			</div>
		</div>



        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الوسط الذي توجد به المؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="id_milieu_auberge" 
						class="form-control @error('id_milieu_auberge') is-invalid @enderror" required>
					<option value="">-- اختر الوسط --</option>
					@foreach($milieux as $milieu)
						<option value="{{ $milieu->id_type }}" 
							{{ old('id_milieu_auberge') == $milieu->id_type ? 'selected' : '' }}>
							{{ $milieu->type_ar }}
						</option>
					@endforeach
				</select>
				@error('id_milieu_auberge')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>           
		</div> 

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> العنوان <span class="text-danger">*</span> </label>
			<div class="col-sm-4">
				<input type="text" name="adresse" 
					   class="form-control @error('adresse') is-invalid @enderror"
					   value="{{ old('adresse') }}">
				@error('adresse')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الترقيم البريدي <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="code_postal" 
					   class="form-control @error('code_postal') is-invalid @enderror"
					   value="{{ old('code_postal') }}">
				@error('code_postal')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>


        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الولاية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="gouvernorat_id" id="gouvernorat_id" 
						class="form-control @error('gouvernorat_id') is-invalid @enderror" required>
					<option value="" disabled selected>اختر الولاية...</option>
					@foreach($gouvernorats as $gouv)
						<option value="{{ $gouv->id_gouver }}" 
							{{ old('gouvernorat_id') == $gouv->id_gouver ? 'selected' : '' }}>
							{{ $gouv->nom_ar }}
						</option>
					@endforeach
				</select>
				@error('gouvernorat_id') 
					<span class="text-danger small d-block">{{ $message }}</span> 
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> المعتمدية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="delegation_id" id="delegation_id" 
						class="form-control @error('delegation_id') is-invalid @enderror" required disabled>
					<option value="" disabled selected>اختر...</option>
				</select>
				@error('delegation_id') 
					<span class="text-danger small d-block">{{ $message }}</span> 
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الهاتف القار <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="contact_tel" 
					   class="form-control @error('contact_tel') is-invalid @enderror"
					   value="{{ old('contact_tel') }}">
				@error('contact_tel')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الفاكس <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="fax" 
					   class="form-control @error('fax') is-invalid @enderror"
					   value="{{ old('fax') }}">
				@error('fax')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> البريد الإلكتروني للمؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="email" name="contact_email" 
					   class="form-control @error('contact_email') is-invalid @enderror"
					   value="{{ old('contact_email') }}">
				@error('contact_email')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> صورة المركب<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="file" name="image" id="image" 
					   class="form-control @error('image') is-invalid @enderror" accept="image/*">
				@error('image')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<!--div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">سعر الليلة (سرير) <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="number" name="prix_lit" step="0.01" min="0" 
					   class="form-control @error('prix_lit') is-invalid @enderror"
					   value="{{ old('prix_lit') }}">
				@error('prix_lit')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div-->


        <h4 class="mt-3"> مدير المؤسسة </h4>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم واللقب <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="nom_directeur" 
					   class="form-control @error('nom_directeur') is-invalid @enderror"
					   value="{{ old('nom_directeur') }}">
				@error('nom_directeur')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الهاتف الجوال <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="tel_directeur" 
					   class="form-control @error('tel_directeur') is-invalid @enderror"
					   value="{{ old('tel_directeur') }}">
				@error('tel_directeur')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<h4 class="mt-3"> الخدمات</h4>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> هل يوجد فضاء للمشروبات ؟ <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="espace_boisson" id="espace_boisson" 
						class="form-control @error('espace_boisson') is-invalid @enderror" required>
					<option value="" disabled selected>اختر...</option>
					<option value="1">نعم</option>
					<option value="0">لا</option>
				</select>
				@error('espace_boisson')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> مسبح  <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="piscine" 
						class="form-control @error('piscine') is-invalid @enderror" required>
					<option value="" disabled selected>اختر...</option>
					<option value="1">نعم</option>
					<option value="0">لا</option>
				</select>
				@error('piscine')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

<div class="form-group row mt-4">
    <h5 class="text-center mb-3">تعريفات الإقامة</h5>

    <table id="tarifs-table" class="table table-bordered">
        <thead class="table-light">
            <tr>
                <th>فرادى / مجموعات</th>
                <th>نوع الوفد المقيم</th>
                <th>
                    <div class="d-flex justify-content-around">
                        <span> بالمباني </span>
                        <span>تحت الخيام</span>
                    </div>
                </th>
                <th>ملاحظات</th>
                <th>إجراء</th>
            </tr>
        </thead>

        <tbody id="tarifs-body">

            <tr>
                <td>
                    <select class="form-control">
					<option value="" disabled selected>اختر...</option>
                        <option>مجموعات</option>
                        <option>أفراد</option>
                    </select>
                </td>

                <td>
				
				









                    <select class="form-control">
					<option value="" disabled selected>اختر...</option>
					   <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td>
                    <div class="d-flex justify-content-around gap-2">
                        <input type="number" class="form-control" placeholder="0" />
                        <input type="number" class="form-control" placeholder="0" />
                    </div>
                </td>

                <td><input type="text" class="form-control" placeholder="ملاحظات"></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteTarifRow(this)">حذف</button>
                </td>
            </tr>

        </tbody>
    </table>

    <div class="text-center mt-3">
            <button type="button" class="btn btn-success px-4" onclick="addTarifRow()">
                إضافة سطر جديد (إقامة)
            </button>
        </div>

        <hr class="my-4">

        
    </div>
<div class="mb-3">

    <!-- Ligne 1 : Label + Input -->
    <div class="d-flex align-items-center gap-3">
        <label class="col-form-label m-0">
            وقف عربات التخييم داخل المركز (في اليوم الواحد)
        </label>

    </div>
<input type="number" class="form-control" style="width:100px;" value="">

    <!-- Ligne 2 : le texte sous la ligne -->
    <span class="text-muted small d-block mt-1">
         اضف القيمة
    </span>

</div>



<script>
function addTarifRow() {
    const row = `
        <tr>
            <td>
                <select class="form-control">
                    <option>مجموعات</option>
                    <option>أفراد</option>
                </select>
            </td>

            <td>
                <select class="form-control">
                    <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                    <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                    <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                    <option>المجموعات الأجنبية (إطار التبادل)</option>
                    <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                </select>
            </td>

            <td>
                <div class="d-flex justify-content-around gap-2">
                    <input type="number" class="form-control" placeholder="0" />
                    <input type="number" class="form-control" placeholder="0" />
                </div>
            </td>

            <td><input type="text" class="form-control" placeholder="ملاحظات"></td>

            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="deleteTarifRow(this)">حذف</button>
            </td>
        </tr>
    `;

    document.getElementById('tarifs-body').insertAdjacentHTML('beforeend', row);
}

function deleteTarifRow(button) {
    button.closest('tr').remove();
}
</script>


        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الفضاءات المتوفرة</h5>

			<table id="espaces-table" class="table table-bordered">
				<thead>
					<tr>
						<th></th>
						<th>الإسم بالعربية</th>
						<th>الإسم بالفرنسية</th>
						<th>الإسم بالانقليزية</th>
						<th>إجراء</th>
					</tr>
				</thead>
				<tbody id="espaces-body">
					<tr>
						<td class="row-number">1</td>
						<td><input type="text" name="espaces[0][nom_ar]" class="form-control" ></td>
						<td><input type="text" name="espaces[0][nom_fr]" class="form-control" ></td>
						<td><input type="text" name="espaces[0][nom_en]" class="form-control" ></td>
						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
						</td>
					</tr>
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addEspaceRow()">إضافة فضاء جديد</button>
		</div>

		<div class="form-group row mt-4">
			<h5 class="text-center mb-3">الغرف <span class="text-danger">*</span></h5>

			@error('chambres')
				<div class="text-danger small mb-2">{{ $message }}</div>
			@enderror

			<table id="chambres-table" class="custom-table">
				<thead>
					<tr>
						<th></th>
						<th>نوع الغرفة</th>
						<th>الطاقة</th>
						<th>رقم الغرفة</th>
						<th>إجراء</th>
					</tr>
				</thead>
				<tbody id="chambres-body">
					@php
						$oldChambres = old('chambres', [
							['type_chambre_id'=>'', 'capacite'=>'', 'num_chambre'=>'']
						]);
					@endphp

					@foreach($oldChambres as $i => $chambre)
					<tr>
						<td class="row-number">{{ $i + 1 }}</td>

						<td>
							<select name="chambres[{{ $i }}][type_chambre_id]" 
									class="form-control type-chambre @error('chambres.'.$i.'.type_chambre_id') is-invalid @enderror" required>
								<option value="">-- اختر النوع --</option>
								@foreach($typesChambres as $t)
									<option value="{{ $t->id_type }}" 
										{{ $chambre['type_chambre_id'] == $t->id_type ? 'selected' : '' }}>
										{{ $t->type_ar }}
									</option>
								@endforeach
							</select>
							@error('chambres.'.$i.'.type_chambre_id')
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						<td>
							<input type="number" name="chambres[{{ $i }}][capacite]" 
								   class="form-control nb-lits @error('chambres.'.$i.'.capacite') is-invalid @enderror" 
								   value="{{ $chambre['capacite'] }}" required>
							@error('chambres.'.$i.'.capacite')
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						<td>
							<input type="text" name="chambres[{{ $i }}][num_chambre]" 
								   class="form-control @error('chambres.'.$i.'.num_chambre') is-invalid @enderror" 
								   value="{{ $chambre['num_chambre'] }}" required>
							@error('chambres.'.$i.'.num_chambre')
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button>
						</td>
					</tr>
					@endforeach
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addChambreRow()">إضافة غرفة جديدة</button>
		</div>


		<div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="number" name="capacite_batiment" id="capacite_batiment" class="form-control" readonly>
            </div>
            <label class="col-sm-2 col-form-label">
                 عدد الغرف <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres" id="nb_chambres" class="form-control" readonly>
            </div>
        </div>
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف الفردية</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_single" id="nb_chambres_single" class="form-control" readonly>
            </div>
            <label class="col-sm-2 col-form-label">
                 عدد الغرف ثنائي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_double" id="nb_chambres_double" class="form-control" readonly>
            </div>
        </div>
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف ثلاثي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_triple" id="nb_chambres_triple" class="form-control" readonly>
            </div>
            <label class="col-sm-2 col-form-label">
                 عدد الغرف رباعي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_quadra" id="nb_chambres_quadra" class="form-control" readonly>
            </div>
        </div>
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف أكثر من رباعي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_plus" id="nb_chambres_plus" class="form-control" readonly>
            </div>

            <label class="col-sm-2 col-form-label">
                 عدد الوحدات الصحية داخل الغرف</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain" class="form-control" value="{{ old('nb_salles_de_bain') }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain_comm" class="form-control" value="{{ old('nb_salles_de_bain_comm') }}">
            </div>
            <label class="col-sm-2 col-form-label">
               عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_tv" class="form-control" value="{{ old('nb_chambres_tv') }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف المكيفة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_clim" class="form-control" value="{{ old('nb_chambres_clim') }}">
            </div>
            <label class="col-sm-2 col-form-label">
               عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_frigo" class="form-control" value="{{ old('nb_chambres_frigo') }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
              طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4">
                <input type="number" name="capacite_tentes" class="form-control" value="{{ old('capacite_tentes') }}">
            </div>
            <label for="cuisine_fonctionnelle" class="col-sm-2 col-form-label">المطبخ وظيفي</label>
            <div class="col-sm-4">
                <select name="cuisine_fonctionnelle" id="cuisine_fonctionnelle" class="form-control">
                    <option value="" disabled selected>اختر...</option>
                    <option value="1">نعم</option>
                    <option value="0">لا</option>
                </select>
            </div>
        </div>

        

        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الملاعب الرياضية</h5>

			<table id="terrains-table" class="table table-bordered">
				<thead>
					<tr>
						<th></th>
						<th>الإسم بالعربية</th>
						<th>الإسم بالفرنسية</th>
						<th>الإسم بالانقليزية</th>
						<th>إجراء</th>
					</tr>
				</thead>
				<tbody id="terrains-body">
					<tr>
						<td class="row-number">1</td>
						<td><input type="text" name="terrains[0][nom_ar]" class="form-control" ></td>
						<td><input type="text" name="terrains[0][nom_fr]" class="form-control" ></td>
						<td><input type="text" name="terrains[0][nom_en]" class="form-control" ></td>
						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeTerrainRow(this)">حذف</button>
						</td>
					</tr>
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addTerrainRow()">إضافة فضاء جديد</button>
		</div>

		<div class="form-group row mt-4">
			<h5 class="text-center mb-3">الخدمات المقدمة من طرف المؤسسة</h5>

			<table id="services_auberge-table" class="table table-bordered">
				<thead>
					<tr>
						<th></th>
						<th>الإسم بالعربية</th>
						<th>الإسم بالفرنسية</th>
						<th>الإسم بالانقليزية</th>
						<th>إجراء</th>
					</tr>
				</thead>
				<tbody id="services_auberge-body">
					<tr>
						<td class="row-number">1</td>
						<td><input type="text" name="services_auberge[0][nom_ar]" class="form-control" ></td>
						<td><input type="text" name="services_auberge[0][nom_fr]" class="form-control" ></td>
						<td><input type="text" name="services_auberge[0][nom_en]" class="form-control" ></td>
						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
						</td>
					</tr>
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addservices_aubergeRow()">إضافة فضاء جديد</button>
		</div>

        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>

			<table id="restauration-table" class="custom-table">
				<thead>
					<tr>
						<th></th>
						<th>الإسم بالعربية</th>
						<th>الإسم بالفرنسية</th>
						<th>الإسم بالإنجليزية</th>
						<th>الوصف بالعربية</th>
						<th>الوصف بالفرنسية</th>
						<th>الوصف بالإنجليزية</th>
						<th>التعريفة (د.ت)</th>
						<th>إجراء</th>
					</tr>
				</thead>

				<tbody id="restauration-body">
					<tr>
						<td class="row-number">1</td>

						<td><input type="text" name="restaurations[0][nom_ar]" class="form-control" ></td>
						<td><input type="text" name="restaurations[0][nom_fr]" class="form-control" ></td>
						<td><input type="text" name="restaurations[0][nom_en]" class="form-control" ></td>

						<td><textarea name="restaurations[0][description_ar]" class="form-control" rows="3"></textarea></td>
						<td><textarea name="restaurations[0][description_fr]" class="form-control" rows="3"></textarea></td>
						<td><textarea name="restaurations[0][description_en]" class="form-control" rows="3"></textarea></td>

						<td><input type="number" step="0.01" name="restaurations[0][tarif]" class="form-control" ></td>

						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
						</td>
					</tr>
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addRestaurationRow()">إضافة خدمة جديدة</button>
		</div>

        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة</label>
            <textarea name="lieux_culturels" id="lieux_culturels" class="form-control" rows="4">{{ old('lieux_culturels') }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label"> خدمات أخرى </label>
            <textarea name="autres_services" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services') }}</textarea>
        </div>


        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success mx-2">
                <i class="la la-save"></i> حفظ
            </button>

            <a href="{{ route('auberges.index') }}" class="btn btn-secondary mx-2">
                <i class="la la-arrow-right"></i> رجوع
            </a>
        </div>

    </form>
</div>


<script>
document.getElementById('gouvernorat_id').addEventListener('change', function() {

    let gouvId = this.value;
    let delegationSelect = document.getElementById('delegation_id');

    delegationSelect.innerHTML = '<option value="" disabled selected>تحميل...</option>';
    delegationSelect.disabled = true;

    let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";
    url = url.replace("ID_PLACEHOLDER", gouvId);

    fetch(url)
        .then(response => response.json())
        .then(data => {

            delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';

            data.forEach(d => {
                let option = document.createElement('option');
                option.value = d.id_delegation;
                option.text = d.nom_ar;
                delegationSelect.add(option);
            });

            delegationSelect.disabled = false;
        });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', () => {
    function updateRowNumbers() {
        document.querySelectorAll('#chambres-body .row-number').forEach((cell, i) => {
            cell.textContent = i + 1;
        });
    }

    function recalculer() {
        const rows = document.querySelectorAll('#chambres-body tr');
        let totalChambres = 0;
        let capaciteTotale = 0;
        let nb_single = 0, nb_double = 0, nb_triple = 0, nb_quadra = 0, nb_plus = 0;

        rows.forEach(row => {
            const typeEl = row.querySelector('.type-chambre');
            const litsEl = row.querySelector('.nb-lits');
            if (!typeEl || !litsEl) return;
            const type = typeEl.value;
            const lits = parseInt(litsEl.value || 0);
            totalChambres++;
            capaciteTotale += lits;
            switch (type) {
                case "1": nb_single++; break;
                case "2": nb_double++; break;
                case "3": nb_triple++; break;
                case "4": nb_quadra++; break;
                case "6": nb_plus++; break;
            }
        });

        if(document.getElementById('nb_chambres')) document.getElementById('nb_chambres').value = totalChambres;
        if(document.getElementById('capacite_batiment')) document.getElementById('capacite_batiment').value = capaciteTotale;
        if(document.getElementById('nb_chambres_single')) document.getElementById('nb_chambres_single').value = nb_single;
        if(document.getElementById('nb_chambres_double')) document.getElementById('nb_chambres_double').value = nb_double;
        if(document.getElementById('nb_chambres_triple')) document.getElementById('nb_chambres_triple').value = nb_triple;
        if(document.getElementById('nb_chambres_quadra')) document.getElementById('nb_chambres_quadra').value = nb_quadra;
        if(document.getElementById('nb_chambres_plus')) document.getElementById('nb_chambres_plus').value = nb_plus;
    }

    window.addChambreRow = function() {
        const tbody = document.getElementById('chambres-body');
        const index = tbody.querySelectorAll('tr').length;

        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td class="row-number">${index + 1}</td>
            <td>
                <select name="chambres[${index}][type_chambre_id]" 
                        class="form-control type-chambre" required>
                    <option value="">-- اختر النوع --</option>
                    @foreach($typesChambres as $t)
                        <option value="{{ $t->id_type }}">{{ $t->type_ar }}</option>
                    @endforeach
                </select>
            </td>
            <td><input type="number" name="chambres[${index}][capacite]" class="form-control nb-lits" required></td>
            <td><input type="text" name="chambres[${index}][num_chambre]" class="form-control" required></td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button></td>
        `;
        tbody.appendChild(tr);
        updateRowNumbers();
        recalculer();
    }

    window.removeChambreRow = function(btn) {
        btn.closest('tr').remove();
        updateRowNumbers();
        recalculer();
    }

    document.addEventListener('input', e => {
        if (e.target.classList.contains('type-chambre') || e.target.classList.contains('nb-lits')) {
            recalculer();
        }
    });

    document.addEventListener('change', e => {
        if (e.target.classList.contains('type-chambre')) {
            recalculer();
        }
    });

    updateRowNumbers();
    recalculer();
});
</script>

<script>
    let restaurationIndex = 1;

    function addRestaurationRow() {
        let tableBody = document.getElementById('restauration-body');

        let newRow = `
            <tr>
                <td class="row-number"></td>

                <td><input type="text" name="restaurations[${restaurationIndex}][nom_ar]" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_fr]" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_en]" class="form-control" ></td>

                <td><textarea name="restaurations[${restaurationIndex}][description_ar]" class="form-control" rows="3"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_fr]" class="form-control" rows="3"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_en]" class="form-control" rows="3"></textarea></td>

                <td><input type="number" step="0.01" name="restaurations[${restaurationIndex}][tarif]" class="form-control" ></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        restaurationIndex++;
        updateRowNumbers();
    }

    function removeRestaurationRow(button) {
        button.closest('tr').remove();
        updateRowNumbers();
    }

    function updateRowNumbers() {
        document.querySelectorAll('#restauration-body .row-number')
            .forEach((cell, index) => cell.textContent = index + 1);
    }

    updateRowNumbers();
</script>

<script>
let espaceIndex = 1;

function addEspaceRow() {
    let tableBody = document.getElementById('espaces-body');

    let newRow = `
        <tr>
            <td class="row-number">${espaceIndex + 1}</td>
            <td><input type="text" name="espaces[${espaceIndex}][nom_ar]" class="form-control" ></td>
            <td><input type="text" name="espaces[${espaceIndex}][nom_fr]" class="form-control" ></td>
            <td><input type="text" name="espaces[${espaceIndex}][nom_en]" class="form-control" ></td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    espaceIndex++;
    updateEspaceRowNumbers();
}

function removeEspaceRow(button) {
    button.closest('tr').remove();
    updateEspaceRowNumbers();
}

function updateEspaceRowNumbers() {
    document.querySelectorAll('#espaces-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>
<script>
let terrainIndex = 1;

function addTerrainRow() {
    let tableBody = document.getElementById('terrains-body');

    let newRow = `
        <tr>
            <td class="row-number">${terrainIndex + 1}</td>
            <td><input type="text" name="terrains[${terrainIndex}][nom_ar]" class="form-control" ></td>
            <td><input type="text" name="terrains[${terrainIndex}][nom_fr]" class="form-control" ></td>
            <td><input type="text" name="terrains[${terrainIndex}][nom_en]" class="form-control" ></td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeTerrainRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    terrainIndex++;
    updateEspaceRowNumbers();
}

function removeTerrainRow(button) {
    button.closest('tr').remove();
    updateTerrainRowNumbers();
}

function updateTerrainRowNumbers() {
    document.querySelectorAll('#terrains-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>
<script>
let services_aubergeIndex = 1;

function addservices_aubergeRow() {
    let tableBody = document.getElementById('services_auberge-body');

    let newRow = `
        <tr>
            <td class="row-number">${services_aubergeIndex + 1}</td>
            <td><input type="text" name="services_auberge[${services_aubergeIndex}][nom_ar]" class="form-control" ></td>
            <td><input type="text" name="services_auberge[${services_aubergeIndex}][nom_fr]" class="form-control" ></td>
            <td><input type="text" name="services_auberge[${services_aubergeIndex}][nom_en]" class="form-control" ></td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    services_aubergeIndex++;
    updateservices_aubergeRowNumbers();
}

function removeservices_aubergeRow(button) {
    button.closest('tr').remove();
    updateservices_aubergeRowNumbers();
}

function updateservices_aubergeRowNumbers() {
    document.querySelectorAll('#services_auberge-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>
@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif