@extends('backoffice.dashboard')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">

                <form method="POST" action="{{ route('chambres.update', $chambre->id_chambre_tente) }}">
                    @csrf
                    @method('PUT')

                    <input type="hidden" name="auberge_id" value="{{ $chambre->auberge_id }}">

                    <div class="block-card mb-4">

                        <div class="block-card-header">
                            <h2 class="widget-title">تعديل غرفة / خيمة</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">
                            <div class="row">
                                <!-- التصنيف -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>التصنيف</label>
                                        <select name="type" class="form-control" required>
                                            <option value=""> اختر</option>
                                            <option value="chambre" {{ $chambre->type == 'chambre' ? 'selected' : '' }}>غرفة</option>
                                            <option value="tente" {{ $chambre->type == 'tente' ? 'selected' : '' }}>خيمة</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- رقم الغرفة -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>رقم الغرفة / الخيمة</label>
                                        <input type="text" name="num_chambre" class="form-control"
                                            value="{{ old('num_chambre', $chambre->num_chambre) }}" required>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <!-- نوع الغرفة -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>نوع الغرفة</label>
                                        <select name="type_chambre_id" class="form-control" required>
                                            <option value="">-- اختر نوع الغرفة --</option>
                                            @foreach($types as $type)
                                                <option value="{{ $type->id_type }}" 
                                                    {{ $chambre->type_chambre_id == $type->id_type ? 'selected' : '' }}>
                                                    {{ $type->type_ar }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <!-- الطاقة الاستيعابية -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>الطاقة الاستيعابية</label>
                                        <input type="number" name="capacite" class="form-control"
                                            value="{{ old('capacite', $chambre->capacite) }}" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                            <i class="la la-save mr-1"></i> حفظ
                        </button>

                        <a href="{{ route('chambres.index', $chambre->auberge_id) }}"
                           class="btn bg-rgb-primary1 font-weight-medium">
                            <i class="la la-times mr-1"></i> إلغاء
                        </a>

                    </div>

                </form>

            </div>
        </div>
    </div>
</section>
</div>

@else
    <script> window.location.href = "{{ route('admin') }}"; </script>
@endif

@endsection
