@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())
<style>
    .my-table table {
    font-size: 14px;
}

.my-table table th {
    font-size: 13px;
    white-space: nowrap;
}

.my-table table td {
    font-size: 13px;
    padding: 6px 8px;
}

/* ==== BADGE MODERNE ==== */
.status-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 8px;
    font-weight: 600;
    min-width: 75px;
    text-align: center;
    transition: 0.3s;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

.status-badge--success {
    background-color: #e8f9ee;
    color: #27ae60;
}
.status-badge--danger {
    background-color: #fde8ea;
    color: #e74c3c;
}
.status-badge--pending {
    background-color: #fff8e1;
    color: #d4a017;
}

/* ==== ACTION BUTTONS ==== */
.actions-cell {
    display: inline-flex;
    align-items: center;
    gap: 6px;
}

.btn-icon {
    width: 30px;
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border: none;
    cursor: pointer;
    background-color: #f8f9fa;
    font-size: 16px;
    transition: 0.2s;
}

.btn-icon:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 5px rgba(0,0,0,0.15);
}

/* couleurs */
.btn-icon--primary {
    background-color: #e3f2fd;
    color: #0d6efd;
}
.btn-icon--danger {
    background-color: #f8d7da;
    color: #dc3545;
}
</style>

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">قائمة التقييمات</h2>
                </div>

                @if(session('success'))
                    <div class="alert alert-success mt-2">{{ session('success') }}</div>
                @endif

                <div class="block-card-body table-responsive">
                    <table class="table table-bordered align-items-center mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>المستخدم</th>
                                <th>المركب الشبابي</th>
                                <th>تاريخ التقييم</th>
                                <th>التقييم</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($avis as $a)
                                <tr>
                                    <td>{{ $a->id_avis }}</td>
                                    <td>{{ $a->user?->nom_prenom ?? 'مستخدم مجهول' }}</td>
                                    <td>{{ $a->auberge?->nom ?? '---' }}</td>
                                    <td>{{ $a->date_avis ? \Carbon\Carbon::parse($a->date_avis)->format('Y-m-d') : '---' }}</td>
                                    <td>
                                        @php
                                            $maxStars = 5;
                                            $fullStars = $a->note ?? 0; // note actuelle
                                        @endphp

                                        @for($i = 1; $i <= $maxStars; $i++)
                                            @if($i <= $fullStars)
                                                <i class="la la-star" style="color: #f1c40f;"></i> {{-- étoile pleine --}}
                                            @else
                                                <i class="la la-star-o" style="color: #ccc;"></i> {{-- étoile vide --}}
                                            @endif
                                        @endfor
                                    </td>

                                    <td>
                                        <div class="d-flex justify-content-center gap-2">

                                            <a href="{{ route('avis.show', $a->id_avis) }}" class="btn-icon btn-icon--primary" title="عرض">
                                                <i class="la la-eye"></i>
                                            </a>

                                            <form action="{{ route('avis.destroy', $a->id_avis) }}" method="POST" style="display:inline;">
    @csrf
    @method('DELETE')
    <button type="button" class="btn-icon btn-icon--danger" title="حذف"
            onclick="confirmDelete(this.closest('form'))">
        <i class="la la-trash"></i>
    </button>
</form>


                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا يوجد تقييمات.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>

                    <div class="mt-3">
                        {{ $avis->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
function confirmDelete(form) {
    Swal.fire({
        icon: 'warning',
        title: 'هل تريد حذف هذا التقييم؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-danger mx-2',
            cancelButton: 'btn btn-secondary'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        }
    });
}
</script>

@else
<script>window.location.href = "{{ route('admin') }}";</script>
@endif

@endsection
