// =====================
// SweetAlert2 Confirm
// =====================
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: message,
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        icon: 'warning',
     

        iconHtml: '<i class="la la-exclamation-triangle"></i>',
        customClass: {
            popup: 'swal-modern-popup',
            title: 'swal-modern-title',
            htmlContainer: 'swal-modern-text',
            confirmButton: 'btn-icon btn-icon--danger',
            cancelButton: 'btn-icon btn-icon--seconjdary',
            icon: 'swal-modern-icon'
        },

        showClass: {
            popup: 'animate__animated animate__fadeInDown animate__faster'
        },
        hideClass: {
            popup: 'animate__animated animate__fadeOutUp animate__faster'
        },
        buttonsStyling: false
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}


// =====================
// Limiter input text
// =====================
document.addEventListener('DOMContentLoaded', function() {
    var textInputs = document.querySelectorAll('input[type="text"]');
    textInputs.forEach(function(input) {
        input.setAttribute('maxlength', '250');
    });
});

// =====================
// Limiter input number
// =====================
document.addEventListener('DOMContentLoaded', function() {
    function limitNumberInputDigits(selector, maxDigits) {
        document.querySelectorAll(selector).forEach(function(input) {
            input.addEventListener('input', function() {
                let value = this.value.replace(/\D/g, '');
                if (value.length > maxDigits) {
                    value = value.slice(0, maxDigits);
                }
                this.value = value;
            });
        });
    }
    limitNumberInputDigits('input[type="number"]', 15);
});


/***********  Utilisateur ***********/

// =====================
// Zone de Recherche
// =====================

function showSearchInput(value) {
        document.getElementById('searchByCIN').style.display = value === 'cin' ? 'block' : 'none';
        document.getElementById('searchByRole').style.display = value === 'role' ? 'block' : 'none';
    }
    document.addEventListener('DOMContentLoaded', function() {
        const option = document.getElementById('search-option').value;
        showSearchInput(option);
});

/***********  Salle de sport ***********/

// ===========================
// modifier statut de demande
// ===========================

/*function confirmStatusChange(form, currentStatus) {
    Swal.fire({
        title: 'هل تريد حقًا تغيير حالة الطلب؟',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false, 
        customClass: {
            confirmButton: 'btn btn-orange me-2', 
            cancelButton: 'btn btn-danger'       
        },
        input: 'radio',
        inputOptions: {
            '1': 'قبول',
            '3': 'رفض'
        },
        inputValidator: (value) => {
            if (!value) return 'اختر الحالة الجديدة!';
        },
        preConfirm: async (value) => {
            if (value === '3') { 
                const result = await Swal.fire({
                    title: 'أدخل سبب الرفض:',
                    input: 'text',
                    inputPlaceholder: 'سبب الرفض',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال سبب الرفض!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false,
                    customClass: {
                        confirmButton: 'btn btn-orange me-2',
                        cancelButton: 'btn btn-danger'
                    }
                });
                if (result.isConfirmed) {
                    return { statut: value, motif: result.value };
                } else {
                    return false;
                }
            }
            return { statut: value };
        }
    }).then((result) => {
        if (!result || !result.value) return;
        const form = button.closest('form');
        const data = result.value;

      
        form.querySelectorAll('input[name="id_statut"], input[name="commentaire_motif"]').forEach(i => i.remove());

        
        const inputStatut = document.createElement('input');
        inputStatut.type = 'hidden';
        inputStatut.name = 'id_statut';
        inputStatut.value = data.statut;
        form.appendChild(inputStatut);

       
        if (data.motif) {
            const inputMotif = document.createElement('input');
            inputMotif.type = 'hidden';
            inputMotif.name = 'commentaire_motif';
            inputMotif.value = data.motif;
            form.appendChild(inputMotif);
        }

        form.submit();
    });
}*/

function confirmStatusChange(form, currentStatus) {
    Swal.fire({
        title: 'هل تريد حقًا تغيير حالة الطلب؟',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
      
        customClass: {
            popup: 'swal-modern-popup',
            title: 'swal-modern-title',
            htmlContainer: 'swal-modern-text',
            confirmButton: 'btn-icon btn-icon--danger',
            cancelButton: 'btn-icon btn-icon--seconjdary',
            icon: 'swal-modern-icon'
        },

        showClass: {
            popup: 'animate__animated animate__fadeInDown animate__faster'
        },
        hideClass: {
            popup: 'animate__animated animate__fadeOutUp animate__faster'
        },
        buttonsStyling: false,
        input: 'radio',
        inputOptions: {
            '1': 'قبول',
            '3': 'رفض'
        },
        inputValidator: (value) => {
            if (!value) return 'اختر الحالة الجديدة!';
        },
        preConfirm: (value) => {
            if (value == '3') {
                return Swal.fire({
                    title: 'أدخل سبب الرفض:',
                    input: 'text',
                    inputPlaceholder: 'سبب الرفض',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال سبب الرفض!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        return { statut: value, motif: result.value };
                    } else {
                        Swal.close();
                        return false;
                    }
                });
            } else {
                return { statut: value };
            }
        }
    }).then((result) => {
        if (!result || !result.isConfirmed) return;

        let data = result.value;
        let inputStatut = document.createElement('input');
        inputStatut.type = 'hidden';
        inputStatut.name = 'id_statut';
        inputStatut.value = data.statut;
        form.appendChild(inputStatut);

        if (data.motif) {
            let inputMotif = document.createElement('input');
            inputMotif.type = 'hidden';
            inputMotif.name = 'commentaire_motif';
            inputMotif.value = data.motif;
            form.appendChild(inputMotif);
        }

        form.submit();
    });
}


function confirmStatusChange2(form, currentStatus) {
    Swal.fire({
        title: 'هل تريد حقًا تغيير حالة الطلب؟',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        customClass: {
            confirmButton: 'btn btn-primary mx-2',
            cancelButton: 'btn btn-secondary'
        },
        buttonsStyling: false,
        input: 'radio',
        inputOptions: {
            '1': 'موافقة',
            '3': 'عدم موافقة',
            '4': 'موافقة شريطة',
            '5': 'ارجاء لابداء الراي'
        },
        inputValidator: (value) => {
            if (!value) return 'اختر الحالة الجديدة!';
        },
        preConfirm: (value) => {
            // Si le statut choisi nécessite un commentaire
            if (value == '3') {
                return Swal.fire({
                    title: 'أدخل سبب الرفض:',
                    input: 'text',
                    inputPlaceholder: 'سبب الرفض',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال سبب الرفض!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        return { statut: value, commentaire_motif: result.value };
                    } else {
                        Swal.close();
                        return false;
                    }
                });
            } else if (value == '4') {
                return Swal.fire({
                    title: 'أدخل التعليق:',
                    input: 'text',
                    inputPlaceholder: 'التعليق',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال التعليق!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        return { statut: value, commentaire_acceptation: result.value };
                    } else {
                        Swal.close();
                        return false;
                    }
                });
            } else if (value == '5') {
                return Swal.fire({
                    title: 'أدخل التعليق:',
                    input: 'text',
                    inputPlaceholder: 'التعليق',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال التعليق!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        return { statut: value, commentaire_avis: result.value };
                    } else {
                        Swal.close();
                        return false;
                    }
                });
            } else {
                return { statut: value }; // statut 1 ou autre
            }
        }
    }).then((result) => {
        if (!result || !result.isConfirmed) return;

        const data = result.value;

        // Ajouter le champ id_statut
        const inputStatut = document.createElement('input');
        inputStatut.type = 'hidden';
        inputStatut.name = 'id_statut';
        inputStatut.value = data.statut;
        form.appendChild(inputStatut);

        // Ajouter le commentaire correspondant
        if (data.commentaire_motif) {
            const inputMotif = document.createElement('input');
            inputMotif.type = 'hidden';
            inputMotif.name = 'commentaire_motif';
            inputMotif.value = data.commentaire_motif;
            form.appendChild(inputMotif);
        }
        if (data.commentaire_acceptation) {
            const inputAcceptation = document.createElement('input');
            inputAcceptation.type = 'hidden';
            inputAcceptation.name = 'commentaire_acceptation';
            inputAcceptation.value = data.commentaire_acceptation;
            form.appendChild(inputAcceptation);
        }
        if (data.commentaire_avis) {
            const inputAvis = document.createElement('input');
            inputAvis.type = 'hidden';
            inputAvis.name = 'commentaire_avis';
            inputAvis.value = data.commentaire_avis;
            form.appendChild(inputAvis);
        }

        form.submit();
    });
}





function confirmStatusChange4(form, currentStatus) {
    Swal.fire({
        title: 'هل تريد حقًا تغيير حالة الطلب؟',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-primary mx-2',
            cancelButton: 'btn btn-secondary'
        },
        input: 'radio',
        inputOptions: {
            '1': 'قبول',
            '3': 'رفض'
        },
        inputValidator: (value) => {
            if (!value) return 'اختر الحالة الجديدة!';
        },
        preConfirm: (value) => {
            if (value == '3') {
                return Swal.fire({
                    title: 'أدخل سبب الرفض:',
                    input: 'text',
                    inputPlaceholder: 'سبب الرفض',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال سبب الرفض!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        return { statut: value, motif: result.value };
                    } else {
                        Swal.close();
                        return false;
                    }
                });
            } else {
                return { statut: value };
            }
        }
    }).then((result) => {
        if (!result || !result.isConfirmed) return;

        let data = result.value;

        let inputStatut = document.createElement('input');
        inputStatut.type = 'hidden';
        inputStatut.name = 'id_statut1';
        inputStatut.value = data.statut;
        form.appendChild(inputStatut);

        if (data.motif) {
            let inputMotif = document.createElement('input');
            inputMotif.type = 'hidden';
            inputMotif.name = 'commentaire_motif1';
            inputMotif.value = data.motif;
            form.appendChild(inputMotif);
        }

        form.submit();
    });
}


function confirmStatusChange6(form, currentStatus) {
    Swal.fire({
        title: 'هل تريد حقًا تغيير حالة الطلب؟',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-primary mx-2',
            cancelButton: 'btn btn-secondary'
        },
        input: 'radio',
        inputOptions: {
            '1': 'قبول',
            '3': 'رفض'
        },
        inputValidator: (value) => {
            if (!value) return 'اختر الحالة الجديدة!';
        },
        preConfirm: (value) => {
            if (value == '3') {
                return Swal.fire({
                    title: 'أدخل سبب الرفض:',
                    input: 'text',
                    inputPlaceholder: 'سبب الرفض',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال سبب الرفض!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        return { statut: value, motif: result.value };
                    } else {
                        Swal.close();
                        return false;
                    }
                });
            } else {
                return { statut: value };
            }
        }
    }).then((result) => {
        if (!result || !result.isConfirmed) return;

        let data = result.value;

        let inputStatut = document.createElement('input');
        inputStatut.type = 'hidden';
        inputStatut.name = 'id_statut2';
        inputStatut.value = data.statut;
        form.appendChild(inputStatut);

        if (data.motif) {
            let inputMotif = document.createElement('input');
            inputMotif.type = 'hidden';
            inputMotif.name = 'commentaire_motif2';
            inputMotif.value = data.motif;
            form.appendChild(inputMotif);
        }

        form.submit();
    });
}


    function toggleMotifInput5() {
        const select = document.getElementById('id_statut');
        const motifDiv = document.getElementById('motifDiv');
        const motifTextarea = document.getElementById('commentaire_motif2');

        if (!select || !motifDiv || !motifTextarea) return;

        if (select.value === '3') {
            // montrer la zone motif
            motifDiv.classList.remove('d-none');
            motifTextarea.required = true;
        } else {
            // masquer la zone motif et enlever l'obligation
            motifDiv.classList.add('d-none');
            motifTextarea.required = false;
            // ne pas forcer l'effacement si tu veux garder la saisie :
            // motifTextarea.value = '';
        }
    }

    // Appel au chargement pour respecter l'état courant (utile pour old() / validation)
    document.addEventListener('DOMContentLoaded', function () {
        toggleMotifInput5();

        // Si tu veux que la confirmation Swal s'affiche au changement de select
        // et empêcher le submit automatique, tu peux écouter le change ici :
        const select = document.getElementById('id_statut');
        if (select) {
            select.addEventListener('change', function (e) {
                // si tu veux seulement afficher la zone sans Swal, commente/remplace la ligne suivante
                toggleMotifInput5();
            });
        }
    });



// ==================
// Zone de Recherche
// ==================
function showSearchInput2(value) {
    document.getElementById('searchByDate').style.display = value === 'date' ? 'block' : 'none';
    document.getElementById('searchByTypeIdentite').style.display = value === 'type_identite' ? 'block' : 'none';
    if(value !== 'type_identite'){
        document.getElementById('inputCIN').style.display = 'none';
        document.getElementById('inputPassport').style.display = 'none';
        document.getElementById('inputFiscal').style.display = 'none';
    }
}

function showIdentityInput2(value) {
    document.getElementById('inputCIN').style.display = value == '1' ? 'block' : 'none';
    document.getElementById('inputPassport').style.display = value == '2' ? 'block' : 'none';
    document.getElementById('inputFiscal').style.display = value == '3' ? 'block' : 'none';
}

document.addEventListener('DOMContentLoaded', function() {
    showSearchInput2(document.getElementById('search-option').value);
    showIdentityInput2(document.getElementById('type_identite_select')?.value || '');
});

// ==================
// Condition statut#2
// ==================
function openDebutActiviteForm(idImm) {
    window.location.href = "{{ route('admin.debut_activite.create') }}" + "?immobilier_id=" + idImm;
}
function openEditActiviteForm(idDebutActivite) {
    window.location.href = "{{ route('admin.debut_activite.edit', ':id') }}".replace(':id', idDebutActivite);
}
function openConsulterActiviteForm(idImm) {
    window.location.href = "{{ route('debut_activite.show', ':id') }}".replace(':id', idImm);
}



/*-- Type Identite (create)--*/

    function showTypeIdentiteInput() {
        var select = document.getElementById('id_type_identite');
        var value = select.value;
        var fields = document.querySelectorAll('.identite-field');
        fields.forEach(f => f.style.display = 'none');

        if(value == '1') { 
            document.getElementById('cin_input').style.display = 'block';
        } else if(value == '2') { 
            document.getElementById('passport_input').style.display = 'block';
        } else if(value == '3') { 
            document.getElementById('num_fiscal_input').style.display = 'block';
        }
    }

/*-- Type Identite (edit)--*/
    function showTypeIdentiteInput2() {
    var select = document.getElementById('id_type_identite');
    if (!select) return; 
    var value = select.value;
    var fields = document.querySelectorAll('.identite-field');
    fields.forEach(f => f.style.display = 'none');

    if(value == '1') { 
        document.getElementById('cin_input').style.display = 'block';
    } else if(value == '2') { 
        document.getElementById('passport_input').style.display = 'block';
    } else if(value == '3') { 
        document.getElementById('num_fiscal_input').style.display = 'block';
    }
}
document.addEventListener('DOMContentLoaded', function() {
    showTypeIdentiteInput2();
});

/*-- Gouvernorat/Delegation --*/
/*
 document.getElementById('gouvernorat_id').addEventListener('change', function() {        let gouvId = this.value;        let delegationSelect = document.getElementById('delegation_id');        delegationSelect.innerHTML = '<option value="" disabled selected>تحميل...</option>';        delegationSelect.disabled = true;        fetch('/delegations/' + gouvId)            .then(response => response.json())            .then(data => {                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';                data.forEach(d => {                    let option = document.createElement('option');                    option.value = d.id_delegation;                    option.text = d.nom_ar;                    delegationSelect.add(option);                });            delegationSelect.disabled = false;            });    });
*/

/*composants immobilier */
    function toggleSection(selectId, sectionId) {
        var sel = document.getElementById(selectId);
        var section = document.getElementById(sectionId);
        if (!sel || !section) return;

        if (sel.value === '1') {
            section.style.display = 'block';
            section.querySelectorAll('input').forEach(function(inp) {
                inp.setAttribute('required','required');
            });
        } else {
            section.style.display = 'none';
            section.querySelectorAll('input').forEach(function(inp) {
                inp.removeAttribute('required');
                inp.value = '';
            });
        }
    }
    document.addEventListener('DOMContentLoaded', function() {
        ['salle_exercice','piscine','vestiaire','unitaires_sanitaire','stockage_conservation','espace_exterieur','garage']
            .forEach(function(id) {
                toggleSection(id,'id_' + id);
            });
    });




(function() {
  const select = document.getElementById('id_statut');
  const rejectDiv = document.getElementById('motifDiv');        // for status 3 (refus)
  const statusDiv = document.getElementById('motifDivStatus'); // for status 4 & 5

  if (!select || !rejectDiv || !statusDiv) return;

  // Ensure both are hidden initially (on first page load)
  rejectDiv.classList.add('d-none');
  statusDiv.classList.add('d-none');

  // Show/hide only when user changes the selection
  select.addEventListener('change', function () {
    const v = String(this.value);

    // show reject textarea only when user picks 3
    if (v === '3') {
      rejectDiv.classList.remove('d-none');
    } else {
      rejectDiv.classList.add('d-none');
    }

    // show status textarea only when user picks 4 or 5
    if (v === '4' || v === '5') {
      statusDiv.classList.remove('d-none');
    } else {
      statusDiv.classList.add('d-none');
    }
  });

})();






/* ***********************************   Debut activite ***************************************/

function setPlaceholder() {
    const idTypeSelect = document.getElementById('id_type_identite');
    const identifiantInput = document.getElementById('identifiant');
    const messageDiv = document.getElementById('message');

    const type = idTypeSelect.value;
    if (type === "1") identifiantInput.placeholder = "ادخل رقم بطاقة التعريف الوطنية (CIN)";
    else if (type === "2") identifiantInput.placeholder = "ادخل رقم جواز السفر (Passport)";
    else if (type === "3") identifiantInput.placeholder = "ادخل الرقم التعريفي الجبائي (Num Fiscal)";
    else identifiantInput.placeholder = "ادخل رقم الهوية";

    identifiantInput.value = "";
    messageDiv.innerHTML = '';
}

function verifierIdentite() {
    const idType = document.getElementById('id_type_identite').value;
    const identifiant = document.getElementById('identifiant').value;
    const sectionIdentite = document.getElementById('sectionIdentite');
    const messageDiv = document.getElementById('message');

    const nomPrenomInput = document.getElementById('nom_prenom');
    const identifiantAffiche = document.getElementById('identifiantAffiche');
    const mandoubiaInput = document.getElementById('mandoubia');
    const utilisateurIdInput = document.getElementById('utilisateur_id');

    if (!idType || !identifiant) {
        messageDiv.innerHTML = '<div class="alert alert-warning">الرجاء اختيار نوع الهوية و إدخال الرقم</div>';
        sectionIdentite.classList.add('d-none');
        return;
    }

    fetch("/admin/debut-activite/verifier-identite", {
        method: 'POST',
        headers: {
            'Content-Type':'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ 
            id_type_identite: idType, 
            identifiant: identifiant, 
            immobilier_id: document.querySelector("input[name='immobilier_id']").value 
        })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            sectionIdentite.classList.remove('d-none');
            nomPrenomInput.value = data.user.nom_prenom;

            if (idType === "1") identifiantAffiche.value = data.user.cin ?? '';
            else if (idType === "2") identifiantAffiche.value = data.user.passport ?? '';
            else if (idType === "3") identifiantAffiche.value = data.user.num_fiscal ?? '';

            mandoubiaInput.value = data.immobilier?.gouvernorat_nom_ar ?? '';
            utilisateurIdInput.value = data.user.id;

            messageDiv.innerHTML = '<div class="alert alert-success">تم التحقق بنجاح</div>';
        } else {
            messageDiv.innerHTML = '<div class="alert alert-danger">رقم الهوية غير مطابق للمستخدم المحدد</div>';
            sectionIdentite.classList.add('d-none');
        }
    })
    .catch(() => {
        messageDiv.innerHTML = '<div class="alert alert-danger">حدث خطأ أثناء التحقق</div>';
        sectionIdentite.classList.add('d-none');
    });
}

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('id_type_identite').addEventListener('change', setPlaceholder);
    document.getElementById('verifierBtn').addEventListener('click', verifierIdentite);
});


    function showTypeIdentiteInput3() {
        var value = document.getElementById('id_type_identite').value;
        document.getElementById('cin_input_wrapper').style.display = 'none';
        document.getElementById('cin_extra_fields').style.display = 'none';
        document.getElementById('passport_field').style.display = 'none';
        document.getElementById('fiscal_field').style.display = 'none';
        if(value == '1') { 
            document.getElementById('cin_input_wrapper').style.display = 'block';
            document.getElementById('cin_extra_fields').style.display = 'flex';
        } else if(value == '2') { 
            document.getElementById('passport_field').style.display = 'flex';
        } else if(value == '3') { 
            document.getElementById('fiscal_field').style.display = 'flex';
        }
    }
    document.addEventListener('DOMContentLoaded', function(){
        var select = document.getElementById('id_type_identite');
        if(select.value) showTypeIdentiteInput3();
    });


function showTypeIdentiteInput4() {
    var select = document.getElementById('id_type_identite');
    var value = select.value;
    document.getElementById('cin_input_wrapper').style.display = 'none';
    document.getElementById('passport_field').style.display = 'none';
    document.getElementById('fiscal_field').style.display = 'none';
    if (value == '1') {         
        document.getElementById('cin_input_wrapper').style.display = 'block';
    } else if (value == '2') {   
        document.getElementById('passport_field').style.display = 'block';
    } else if (value == '3') {   
        document.getElementById('fiscal_field').style.display = 'block';
    }
}



 function toggleMotifInput4() {
        const select = document.getElementById('id_statut');
        const motifDiv = document.getElementById('motifDiv');

        if (select.value === '3') {
            motifDiv.classList.remove('d-none');
        } else {
            motifDiv.classList.add('d-none');
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        toggleMotifInput4();
    });




 function toggleMotifInput8() {
        const select = document.getElementById('id_type');
        const motifDiv = document.getElementById('motifDiv');

        if (select.value === '3') {
            motifDiv.classList.remove('d-none');
        } else {
            motifDiv.classList.add('d-none');
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        toggleMotifInput8();
    });





