<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projet_divertissement_jeune_enfant', function (Blueprint $table) {
            $table->bigIncrements('id_projet'); 

            $table->unsignedBigInteger('id_investissement');
            $table->unsignedBigInteger('nature_projet_id');
            $table->unsignedBigInteger('id_directeur');

            $table->integer('nbr_diplome_universitaire');
            $table->integer('nbr_autre');

            $table->boolean('espace_spectacle')->default(false);
            $table->text('caracteristique_spec')->nullable();

            $table->boolean('espace_sportif')->default(false);
            $table->text('caracteristique_sportif')->nullable();

            $table->boolean('espace_activite_service')->default(false);
            $table->text('caracteristique_activite_serv')->nullable();

            $table->boolean('espace_activite_culturelle')->default(false);
            $table->text('caracteristique_activite_cult')->nullable();

            $table->text('remarques')->nullable();

            $table->foreign('id_investissement')->references('id_inv')->on('investissement')->onDelete('cascade');
            $table->foreign('nature_projet_id')->references('id_nature_p')->on('tp_nature_projet')->onDelete('cascade');
            $table->foreign('id_directeur')->references('id_directeur')->on('directeur_etablissement')->onDelete('cascade');

            $table->timestamps();
        });


    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projet_divertissement_jeune_enfant');
    }
};
