<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investissement', function (Blueprint $table) {
            $table->bigIncrements('id_inv');
            $table->unsignedInteger('investisseur_id');
            $table->unsignedInteger('type_invest_id');
            $table->unsignedInteger('secteur_invest_id');
            $table->decimal('montant', 18, 2);
            $table->unsignedInteger('id_source_financement');
            $table->string('remarques', 150)->nullable();

            // Relations (clés étrangères)
            $table->foreign('investisseur_id')->references('id')->on('investisseur')->onDelete('cascade');
            $table->foreign('type_invest_id')->references('Id_type_inv')->on('tp_type_investissement')->onDelete('cascade');
            $table->foreign('secteur_invest_id')->references('id_secteur')->on('tp_secteur_investissement')->onDelete('cascade');
            $table->foreign('id_source_financement')->references('Id_source')->on('tp_source_financement')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investissement');
    }
};
