<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('debut_activites', function (Blueprint $table) {
            // id_type_formulaire référence tp_type_formulaire(id_type)
            $table->unsignedBigInteger('id_type_formulaire')->nullable();
            $table->foreign('id_type_formulaire')
                  ->references('id_type')
                  ->on('tp_type_formulaire')
                  ->onDelete('set null');

            // commentaire_motif
            $table->string('commentaire_motif', 255)->nullable();

            // id_statut référence tp_statut(id_statut)
            $table->unsignedBigInteger('id_statut')->nullable();
            $table->foreign('id_statut')
                  ->references('id_statut')
                  ->on('tp_statut')
                  ->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('debut_activites', function (Blueprint $table) {
            $table->dropForeign(['id_type_formulaire']);
            $table->dropColumn('id_type_formulaire');

            $table->dropColumn('commentaire_motif');

            $table->dropForeign(['id_statut']);
            $table->dropColumn('id_statut');
        });
    }
};
