<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('debut_activites', function (Blueprint $table) {
            $table->bigIncrements('id_debut');  
            $table->unsignedBigInteger('immobilier_id');
            $table->date('date_debut_activite');
            $table->string('preuve_propriete_location', 255);
            $table->string('plan_architectural', 255);
            $table->string('declaration_investissement', 255);
            $table->string('identification', 255);
            $table->string('extrait_registre_national_entreprise', 255);
            $table->string('certificat_prevention', 255);
            $table->string('contrat_assurance', 255);
            $table->string('approbation_autorite_minicipale', 255);

            $table->foreign('immobilier_id')
                ->references('id_imm')->on('immobilier')
                ->onDelete('cascade');
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('debut_activites');
    }
};
