<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('etrangere', function (Blueprint $table) {
            $table->id(); 
            $table->string('nom_prenom', 100);
            $table->string('pays_origine', 50);
            $table->string('num_passport', 12)->unique();
            $table->date('date_arrive');
            $table->string('lieu_residence', 50)->nullable();
            $table->date('date_depart');

            $table->unsignedBigInteger('even_id');
            $table->foreign('even_id')
                  ->references('id_even')
                  ->on('evenement_sportif')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('type_etranger_id');
            $table->foreign('type_etranger_id')
                  ->references('id_type')
                  ->on('tp_type_etrangere')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('etrangere');
    }
};
