<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sportif_participants', function (Blueprint $table) {
            $table->id('id_sportif'); 
            $table->string('nom_prenom', 100);
            $table->string('tranch_age', 50)->nullable();
            $table->date('date_naissance');
            $table->string('num_cin', 20)->unique(); 
            $table->boolean('invitee')->default(false); 

            $table->unsignedBigInteger('even_id');
            $table->foreign('even_id')
                  ->references('id_even')
                  ->on('evenement_sportif')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('jeune_id');
            $table->foreign('jeune_id')
                  ->references('id_jeune')
                  ->on('jeune_creatif')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sportif_participants');
    }
};
