<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('membre_org_invite', function (Blueprint $table) {
            $table->id('id_membre'); 
            $table->string('nom_prenom', 100);
            $table->string('role', 50)->nullable();
            $table->string('nationalite', 100)->nullable();
            
            $table->unsignedBigInteger('event_id');
            $table->unsignedBigInteger('type_membre_id');

            $table->foreign('event_id')
                  ->references('id_even')
                  ->on('evenement_sportif')
                  ->onDelete('cascade');

            $table->foreign('type_membre_id')
                  ->references('id_type')
                  ->on('tp_type_membre')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('membre_org_invite');
    }
};
