<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id('id_P');
            $table->string('titre_P', 100);
            $table->integer('ordre_P');
            $table->string('image_titre', 255)->nullable();
            $table->unsignedBigInteger('id_G');
            $table->timestamps();

            $table->foreign('id_G')
                  ->references('id_G')
                  ->on('guides')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pages');
    }
};
