<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('avis', function (Blueprint $table) {
            $table->id('id_avis'); 
            $table->integer('note')->notNull();
            $table->date('date_avis')->notNull();
            $table->string('commentaire', 255)->nullable();
            $table->timestamps();

            $table->unsignedBigInteger('auberge_id');
            $table->unsignedBigInteger('user_id');

            $table->foreign('auberge_id')
                  ->references('id')
                  ->on('auberge')
                  ->onDelete('cascade');

            $table->foreign('user_id')
                  ->references('id')
                  ->on('utilisateur')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('avis');
    }
};
