<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reservation', function (Blueprint $table) {
            $table->id('id_reserv');
            $table->date('date_arrive');
            $table->date('date_depart');
            $table->date('date_reserv');
            $table->unsignedBigInteger('chambre_id');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('statut_id');
            $table->string('commentaire_motif', 255)->nullable();
            $table->timestamps();

            $table->foreign('chambre_id')
                  ->references('id_chambre_tente')
                  ->on('chambre_tente')
                  ->onDelete('cascade');

            $table->foreign('user_id')
                  ->references('id')
                  ->on('utilisateur')
                  ->onDelete('cascade');

            $table->foreign('statut_id')
                  ->references('id_statut')
                  ->on('tp_statut')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reservation');
    }
};
