<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   
    public function up(): void
    {
        Schema::create('disponibilite', function (Blueprint $table) {
            $table->id('id_dispo');
            $table->date('date');
            $table->boolean('est_dispo');
            $table->unsignedBigInteger('chambre_id');
            $table->timestamps();

            $table->foreign('chambre_id')
                  ->references('id_chambre_tente')
                  ->on('chambre_tente')
                  ->onDelete('cascade');
        });
    }

   
    public function down(): void
    {
        Schema::dropIfExists('disponibilite');
    }
};
