<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   
    public function up(): void
    {
        Schema::create('tarif', function (Blueprint $table) {
            $table->id('id_tarif');
            $table->unsignedBigInteger('chambre_id');
            $table->date('date_debut')->nullable();
            $table->date('date_fin')->nullable();
            $table->float('prix', 8, 3);
            $table->timestamps();

            $table->foreign('chambre_id')
                  ->references('id_chambre_tente')
                  ->on('chambre_tente')
                  ->onDelete('cascade');
        });
    }

    
    public function down(): void
    {
        Schema::dropIfExists('tarif');
    }
};
