<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tp_delegation', function (Blueprint $table) {
            $table->id('id_delegation');
            $table->string('nom_fr', 100);
            $table->string('nom_ar', 100);
            $table->string('nom_en', 100);
            $table->unsignedBigInteger('gouver_id');

            // clé étrangère vers tp_gouvernorat
            $table->foreign('gouver_id')
                ->references('id_gouver')
                ->on('tp_gouvernorat')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tp_delegation');
    }
};
