<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class StatutDocumentNotification extends Notification
{
    use Queueable;

    protected $docList;
    protected $statut;
    protected $motif;

    public function __construct($docList, $statut, $motif = null)
    {
        $this->docList = $docList;
        $this->statut = $statut;
        $this->motif = $motif;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        $numDossier = $this->docList->created_at->format('Y') . '_' .
                      ($this->docList->user->cin ?? '00000000') . '_' .
                      str_pad($this->docList->id_doc_list, 3, '0', STR_PAD_LEFT) . '_00';

        return [
            'titre' => 'تم تحديث حالة طلبك',
            'message' => $this->getMessageText(),
            'num_dossier' => $numDossier,
            'statut' => $this->statut,
            'motif' => $this->motif,
        ];
    }

    private function getMessageText()
    {
        if ($this->statut == 1) {
            return 'تم قبول طلبك للوثائق التمويلية من طرف لجنة التمويل العمومي.';
        } elseif ($this->statut == 3) {
            $motif = $this->motif ?? 'سبب غير محدد';
            return "تم رفض طلبك للوثائق التمويلية. السبب: {$motif} من طرف لجنة التمويل العمومي.";
        } else {
            return 'طلبك قيد المعالجة من طرف لجنة التمويل العمومي.';
        }
    }
}
