<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class StatutDemande2Notification extends Notification
{
    use Queueable;

    public $numDossier;
    public $messageStatus;
    public $type;

    public function __construct($numDossier, $messageStatus)
    {
        $this->numDossier = $numDossier;
        $this->messageStatus = $messageStatus;
        $this->type = strpos($messageStatus, 'قبول') !== false ? 'accepte' : 'refuse';
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('تحديث حالة الملف')
            ->view('emails.demande.status2', [
                'utilisateur' => $notifiable,
                'numeroDossier' => $this->numDossier,
                'messageStatus' => $this->messageStatus
            ]);
    }

    // Stocker dans la base pour le dropdown

    public function toArray($notifiable)
    {
        return [
            'num_dossier' => $this->numDossier,
            'message' => $this->messageStatus, // <- clé 'message' ajoutée
            'type' => $this->type,
            'date' => now()->format('Y-m-d H:i:s'),
        ];
    }

}
