<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class ReservationRejectedNotification extends Notification
{
    use Queueable;

    public $reservation;
    public $motif;

    public function __construct($reservation, $motif)
    {
        $this->reservation = $reservation;
        $this->motif = $motif;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toArray($notifiable)
    {
        return [
            'title' => 'تم رفض طلبكم',
            'message' => "
                مرحباً {$this->reservation->user->nom_prenom},
                رقم الملف: {$this->reservation->formatted_dossier}
                نأسف لإعلامكم بأن طلبكم \"{$this->reservation->objet}\" قد تم رفضه.
                السبب: {$this->motif}
                التاريخ: {$this->reservation->created_at->format('Y-m-d')}
            ",
            'reservation_id' => $this->reservation->id,
        ];
    }
}
