<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class ReservationAcceptedNotification extends Notification
{
    use Queueable;

    public $reservation;

    public function __construct($reservation)
    {
        $this->reservation = $reservation;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toArray($notifiable)
    {
        return [
            'title' => 'تم قبول طلبكم',
            'message' => "
                مرحباً {$this->reservation->user->nom_prenom},
                رقم الملف: {$this->reservation->formatted_dossier}
                 تم قبول طلبكم الحجز \" بتاريخ: {$this->reservation->created_at->format('Y-m-d')}.
                نهنئكم على هذا القبول.
            ",
            'reservation_id' => $this->reservation->id,
        ];
    }
}
