<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class DocumentStatusNotification extends Notification
{
    use Queueable;

    public $messageStatus;
    public $numeroDossier;

    public function __construct($messageStatus, $numeroDossier)
    {
        $this->messageStatus = $messageStatus;
        $this->numeroDossier = $numeroDossier;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        return [
            'message' => strip_tags($this->messageStatus),
            'num_dossier' => $this->numeroDossier,
        ];
    }

    public function toArray($notifiable)
    {
        return [
            'message' => strip_tags($this->messageStatus),
            'num_dossier' => $this->numeroDossier,
        ];
    }
}
