<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class DebutActiviteStatutNotification extends Notification
{
    use Queueable;

    public $type;
    public $commentaire;

    public function __construct($type, $commentaire = null)
    {
        $this->type = $type;
        $this->commentaire = $commentaire;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        return [
            'type' => $this->type,
            'message' => $this->type === 'accepte' 
                ? "طلبكم قد تم قبوله "
                : "طلبكم قد تم رفضه. سبب الرفض: ".$this->commentaire,
            'date' => now(),
        ];
    }

    // Optionnel : si tu veux aussi envoyer par mail
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('رد على طلبكم المتعلق ببدء النشاط')
                    ->markdown('emails.salle_sport.statut_mail', [
                        'type' => $this->type,
                        'commentaire' => $this->commentaire,
                        'user' => $notifiable,
                    ]);
    }
}
