<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Models\Identite_personnel;
use App\Models\Role;

class Utilisateur extends Authenticatable
{
    use Notifiable;

    protected $table = 'utilisateur';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'nom_prenom',
        'id_type_identite',
        'cin',
        'date_delivrance_cin',
        'lieu_delivrance_cin',
        'passport',
        'num_fiscal',
        'email',
        'mdp',
        'remember_token',
        'image',
        'tel',
        'adresse',
        'est_active',
        'lieu_naissance',
        'date_naissance',
        'niveau_etude',
        'dernier_diplome',
        'experience',
    ];

    protected $casts = [        
        'est_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    protected $hidden = [
        'mdp',
        'remember_token',
    ];

    public function getAuthPassword()
    {
        return $this->mdp;
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'user_roles', 'user_id', 'roles_id');
    }

    public function hasRole($roleName)
    {
        return $this->roles()->where('nom_ar', $roleName)
                             ->orWhere('nom_fr', $roleName)
                             ->orWhere('nom_en', $roleName)
                             ->exists();
    }

    /*public function hasPermission($permissionName)
    {
        return $this->roles()->whereHas('permissions', function($q) use ($permissionName) {
            $q->where('name', $permissionName);
        })->exists();
    }*/

    /*public function hasPermission($permissionName)
    {
        return $this->roles()->whereHas('permissions', function($q) use ($permissionName) {
            $q->where('nom_ar', $permissionName)
            ->orWhere('nom_fr', $permissionName)
            ->orWhere('nom_en', $permissionName);
        })->exists();
    }*/

    public function hasPermission($permissionId)
    {
        return $this->roles()->whereHas('permissions', function($q) use ($permissionId) {
            $q->where('permissions.id_perm', $permissionId);
        })->exists();
    }


    public function typeIdentite()
    {
        return $this->belongsTo(Identite_personnel::class, 'id_type_identite', 'id_type');
    }

    public function immobiliers()
    {
        return $this->hasMany(Immobilier::class, 'user_id');
    }

    public function tropheesSportifs()
    {
        return $this->hasMany(TropheeSportif::class, 'id_user', 'id');
    }

    public function news()
    {
        return $this->hasMany(News::class, 'id_user', 'id');
    }

    public function sliders()
    {
        return $this->hasMany(Slider::class, 'id_user');
    }

}
