<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MembreOrgInvite extends Model
{
    use HasFactory;

    protected $table = 'membre_org_invite';

    protected $primaryKey = 'id_membre';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'nom_prenom',
        'role',
        'nationalite',
        'event_id',
        'type_membre_id',
    ];

    public function evenement()
    {
        return $this->belongsTo(EvenementSportif::class, 'event_id', 'id_even');
    }

    public function typeMembre()
    {
        return $this->belongsTo(TpTypeMembre::class, 'type_membre_id', 'id_type');
    }
}
