<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JeuneCreatif extends Model
{
    use HasFactory;

    protected $table = 'jeune_creatif';

    protected $primaryKey = 'id_jeune';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'presentez_vous',
        'nom_prenom',
        'email',
        'adresse',
        'niveau_education',
        'formation',
        'experiences',
        'presentation_detaillee',
        'gouvernorat_id',
        'domaine_id',
    ];


    public function gouvernorat()
    {
        return $this->belongsTo(Gouvernorat::class, 'gouvernorat_id', 'id');
    }

    public function domaine()
    {
        return $this->belongsTo(TpDomaineEducation::class, 'domaine_id', 'id_domaine');
    }
}
