<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentsFinancementList extends Model
{
    use HasFactory;

    protected $table = 'documents_financement_list';

    protected $primaryKey = 'id_doc_list';

    public $timestamps = true;

    protected $fillable = [
        'id_projet',
        'id_user',
        'id_formulaire',
        'id_statut1',
        'commentaire_motif1',
        'id_statut2',
        'commentaire_motif2',
        'decision_finale'
    ];

    public function documents()
    {
        return $this->hasMany(DocumentsFinancement::class, 'id_doc_list', 'id_doc_list');
    }

    public function projet()
    {
        return $this->belongsTo(Projet::class, 'id_projet', 'id_projet');
    }

    public function formulaire()
    {
        return $this->belongsTo(TpTypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function statut1()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut1', 'id_statut');
    }

    public function statut2()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut2', 'id_statut');
    }

    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }

}