<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Type extends Model
{
    use HasFactory;

    protected $table = 'tp_type';

    protected $primaryKey = 'id_type';

    public $incrementing = true;

    protected $keyType = 'int';

    protected $fillable = [
        'type_ar',
        'type_fr',
        'type_en',
    ];

    public function guides()
    {
        return $this->hasMany(Guide::class, 'id_type');
    }
}
