<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TerrainSportifAuberge extends Model
{
    use HasFactory;

    protected $table = 'terrain_sportif_auberge';

    protected $primaryKey = 'id_terrain';

    protected $fillable = [
        'nom_ar',
        'nom_fr',
        'nom_en',
        'id_auberge',
    ];

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'id_auberge', 'id');
    }
}
