<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TeamsAssociation extends Model
{
    use HasFactory;

    protected $table = 'teams_associations';

    protected $primaryKey = 'id_team';

    public $incrementing = true;

    protected $keyType = 'int';

    protected $fillable = [
        'nom',
        'pays',
        'category',
        'demande_id',
    ];

    public $timestamps = true;

    public function demande()
    {
        return $this->belongsTo(DemandesManifestation::class, 'demande_id', 'id_demande');
    }
}
