<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SportifParticipant extends Model
{
    use HasFactory;

    protected $table = 'sportif_participants';

    protected $primaryKey = 'id_sportif';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'nom_prenom',
        'tranch_age',
        'date_naissance',
        'num_cin',
        'invitee',
        'even_id',
        'jeune_id',
    ];


    public function evenement()
    {
        return $this->belongsTo(EvenementSportif::class, 'even_id', 'id_even');
    }

    public function jeune()
    {
        return $this->belongsTo(JeuneCreatif::class, 'jeune_id', 'id_jeune');
    }
}
