<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RestaurationAuberge extends Model
{
    use HasFactory;

    protected $table = 'restaurations_auberge'; 

    protected $primaryKey = 'id_rest';

    protected $keyType = 'int';

    public $incrementing = true;

    protected $fillable = [
        'auberge_id',
        'nom_fr',
        'nom_ar',
        'nom_en',
        'description_fr',
        'description_ar',
        'description_en',
        'tarif',
    ];

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'auberge_id');
    }
    
}
