<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReservationRoomAssignment extends Model
{
    protected $table = 'reservation_room_assignments';

    // clé primaire NON standard
    protected $primaryKey = 'id_reserv_room';

    // auto-increment est actif
    public $incrementing = true;

    // type clé primaire
    protected $keyType = 'int';

    // colonnes autorisées
    protected $fillable = [
        'reservation_id',
        'room_type',
        'capacity',
        'rooms_assigned',
        'male_assigned',
        'female_assigned',
        'details',
    ];

    // Le JSON → automatiquement casté en tableau
    protected $casts = [
        'details' => 'array',
    ];

    // Relation avec Reservation
    public function reservation()
    {
        return $this->belongsTo(Reservation::class, 'reservation_id', 'id_reserv');
    }
}
