<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReservationChambreTente extends Model
{
    protected $table = 'reservation_chambre_tente';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'reservation_id',
        'chambre_tente_id',
        'personnes_affectees',
        'male_personnes',
        'female_personnes',
        'total_personnes',
        'capacite_restante'       
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class, 'reservation_id', 'id_reserv');
    }

    public function chambre()
    {
        return $this->belongsTo(ChambreTente::class, 'chambre_tente_id', 'id_chambre_tente');
    }
}
