<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosteDepense extends Model
{
    use HasFactory;

    protected $table = 'postes_depense';
    protected $primaryKey = 'id_depene';
    public $timestamps = false;

    protected $fillable = [
        'id_estimation_budget',
        'libelle_depense',
        'description',
        'cout',
    ];

    public function estimationBudget()
    {
        return $this->belongsTo(EstimationBudget::class, 'id_estimation_budget', 'id_estimation');
    }
}
