<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrganismeNonSportif extends Model
{
    use HasFactory;

    protected $table = 'organismes_non_sportifs';

    protected $primaryKey = 'id_org';

    public $incrementing = true;

    protected $keyType = 'int';

    protected $fillable = [
        'nom',
        'num_visa',
        'date_enregistrement',
        'num_enregistrement',
        'identifiant_fiscal',
        'num_compte_bancaire',
        'adresse',
        'tel',
        'fax',
        'email',
        'type_formulaire_id',
    ];

    public $timestamps = true;

    public function typeFormulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'type_formulaire_id', 'id_type');
    }
}
